/*
 * Decompiled with CFR 0.152.
 */
package freelancer;

import freelancer.DataParser;
import freelancer.IUserInterface;
import freelancer.MapDialog;
import freelancer.PositiveSpinnerModel;
import freelancer.filter.FilterDialog;
import freelancer.filter.TradeRouteFilter;
import freelancer.traderoutes.ITradeRouteTableModel;
import freelancer.traderoutes.MultiStopTradeRoute;
import freelancer.traderoutes.MultiStopTradeRouteDialog;
import freelancer.traderoutes.MultiStopTradeRouteTableModel;
import freelancer.traderoutes.TradeRoute;
import freelancer.traderoutes.TradeRouteCellRenderer;
import freelancer.traderoutes.TradeRouteTableModel;
import freelancer.universe.Base;
import freelancer.universe.ITradePoint;
import freelancer.universe.StarSystem;
import freelancer.universe.Territory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class JavaCargoComputer
extends JFrame
implements IUserInterface {
    public static final int NORMAL_ROUTES = 0;
    public static final int MULTI_STOP_ROUTES = 1;
    public static final int ROUND_TRIP_ROUTES = 2;
    private DataParser mo_DataParser;
    private MapDialog mo_MapDialog;
    private TradeRouteTableModel mo_TableModel;
    private MultiStopTradeRouteTableModel mo_MultiStopTableModel;
    private TradeRouteCellRenderer mo_CellRenderer;
    private TradeRouteFilter mo_Filter;
    private MultiStopTradeRouteDialog mo_MultiStopTradeRouteDialog;
    private CalculationThread mo_CalculationThread;
    private NumberFormat mo_DollarFormat;
    private Object mo_Start;
    private Object mo_Destination;
    private boolean mb_Sortable;
    private int mi_TradeRouteMode;
    private JRadioButton mo_RBtnSystemStart;
    private JSeparator jSeparator2;
    private JSeparator jSeparator4;
    private JScrollPane mo_ScrTradeRoutes;
    private ButtonGroup mo_BtnGrpTarget;
    private JLabel mo_LblStatus;
    private JSeparator jSeparator5;
    private JButton mo_BtnAdjustDestination;
    private JMenuItem mo_MniShips;
    private JMenuItem mo_MniLoadSettings;
    private JMenu mo_MnuFile;
    private JMenuItem mo_MniSetFilter;
    private JMenuItem mo_MniShowMap;
    private JRadioButton mo_RBtnTerritoryTarget;
    private JLabel mo_LblMoney;
    private JButton mo_BtnCalculate;
    private JRadioButton mo_RBtnBaseStart;
    private JRadioButtonMenuItem mo_RbmModeMultiPlayer;
    private JLabel mo_LblSelectedRouteDetails;
    private JCheckBoxMenuItem mo_CbmAutoSave;
    private JMenu mo_MnuFilter;
    private JButton mo_BtnSelectBestRoute;
    private JPanel mo_PnlStart;
    private JPanel mo_PnlSelectedRoute;
    private JPanel mo_PnlTarget;
    private JLabel mo_LblSelectedRoute;
    private JCheckBoxMenuItem mo_CbmHideLength;
    private JPanel mo_PnlSwitches;
    private JProgressBar mo_PgbCalculation;
    private JSeparator jSeparator3;
    private ButtonGroup mo_BtnGrpTradeRouteMode;
    private JMenu mo_MnuMap;
    private JRadioButton mo_RBtnUniverseStart;
    private JTable mo_TblTradeRoutes;
    private JMenu mo_MnuShips;
    private JMenu mo_MnuTradeRoutes;
    private JMenuBar mo_MnuMainMenu;
    private JButton mo_BtnSwitchLocations;
    private JCheckBoxMenuItem mo_CbmHideFactions;
    private JCheckBoxMenuItem mo_CbmHideCommodities;
    private JComboBox mo_CbbStart;
    private JRadioButton mo_RBtnSystemTarget;
    private ButtonGroup mo_BtnGrpStart;
    private ButtonGroup mo_BtnGrpMapMode;
    private JComboBox mo_CbbTarget;
    private JRadioButtonMenuItem mo_RbmRoundTrip;
    private JRadioButton mo_RBtnUniverseTarget;
    private JRadioButton mo_RBtnBaseTarget;
    private JSpinner mo_SprCargo;
    private JButton mo_BtnAdjustStart;
    private JLabel mo_LblCargo;
    private JRadioButtonMenuItem mo_RbmNormal;
    private JRadioButtonMenuItem mo_RbmMultiStop;
    private JSeparator jSeparator1;
    private JMenuItem mo_MniSaveSettings;
    private JSpinner mo_SprMoney;
    private JRadioButtonMenuItem mo_RbmModeSinglePlayer;
    private JPopupMenu mo_PMnuTradeRoute;
    private JRadioButton mo_RBtnTerritoryStart;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Double;

    public JavaCargoComputer() throws Exception {
        long ll_StartTime = System.currentTimeMillis();
        this.mo_CalculationThread = null;
        this.mb_Sortable = true;
        this.mi_TradeRouteMode = 0;
        this.mo_DollarFormat = NumberFormat.getCurrencyInstance(Locale.US);
        this.mo_DollarFormat.setMaximumFractionDigits(0);
        this.mo_TableModel = new TradeRouteTableModel();
        this.mo_TableModel.setUserInterface(this);
        this.mo_MultiStopTableModel = new MultiStopTradeRouteTableModel();
        this.mo_MultiStopTableModel.setUserInterface(this);
        this.mo_CellRenderer = new TradeRouteCellRenderer();
        this.mo_DataParser = new DataParser();
        this.mo_Filter = new TradeRouteFilter();
        this.mo_CellRenderer.setFilter(this.mo_Filter);
        this.mo_DataParser.setFilter(this.mo_Filter);
        this.mo_MultiStopTradeRouteDialog = new MultiStopTradeRouteDialog((Frame)this, false);
        this.mo_MapDialog = new MapDialog((Frame)this, false);
        this.mo_MapDialog.setDataParser(this.mo_DataParser);
        this.initComponents();
        this.mo_RbmNormal.setSelected(true);
        this.mo_MnuMainMenu.remove(4);
        this.mo_MnuTradeRoutes.remove(this.mo_RbmRoundTrip);
        this.mo_PgbCalculation.setVisible(false);
        JTextField lo_TextField = new JTextField();
        lo_TextField.setHorizontalAlignment(4);
        lo_TextField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent ao_Event) {
                block2: {
                    if (ao_Event.getKeyCode() != 10) break block2;
                    try {
                        JavaCargoComputer.this.mo_SprCargo.setValue(((JTextField)JavaCargoComputer.this.mo_SprCargo.getEditor()).getText());
                        JavaCargoComputer.this.mo_MultiStopTableModel.setAvailableCargo(((PositiveSpinnerModel)JavaCargoComputer.this.mo_SprCargo.getModel()).getValueAsInt());
                    }
                    catch (Exception ex) {
                        JavaCargoComputer.this.mo_SprCargo.setValue(JavaCargoComputer.this.mo_SprCargo.getValue());
                    }
                }
            }
        });
        lo_TextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent ao_Event) {
                try {
                    JavaCargoComputer.this.mo_SprCargo.setValue(((JTextField)JavaCargoComputer.this.mo_SprCargo.getEditor()).getText());
                    JavaCargoComputer.this.mo_MultiStopTableModel.setAvailableCargo(((PositiveSpinnerModel)JavaCargoComputer.this.mo_SprCargo.getModel()).getValueAsInt());
                }
                catch (Exception ex) {
                    JavaCargoComputer.this.mo_SprCargo.setValue(JavaCargoComputer.this.mo_SprCargo.getValue());
                }
            }
        });
        this.mo_SprCargo.setEditor(lo_TextField);
        this.mo_SprCargo.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent ao_Event) {
                int li_SelectedRow = JavaCargoComputer.this.mo_TblTradeRoutes.getSelectedRow();
                if (li_SelectedRow != -1) {
                    JavaCargoComputer.this.mo_TblTradeRoutes.getSelectionModel().clearSelection();
                    JavaCargoComputer.this.mo_TblTradeRoutes.setRowSelectionInterval(li_SelectedRow, li_SelectedRow);
                    JavaCargoComputer.this.mo_MultiStopTableModel.setAvailableCargo(((PositiveSpinnerModel)JavaCargoComputer.this.mo_SprCargo.getModel()).getValueAsInt());
                }
                ((JTextField)JavaCargoComputer.this.mo_SprCargo.getEditor()).setText((String)JavaCargoComputer.this.mo_SprCargo.getValue());
            }
        });
        lo_TextField = new JTextField();
        lo_TextField.setHorizontalAlignment(4);
        lo_TextField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent ao_Event) {
                block2: {
                    if (ao_Event.getKeyCode() != 10) break block2;
                    try {
                        JavaCargoComputer.this.mo_SprMoney.setValue(((JTextField)JavaCargoComputer.this.mo_SprMoney.getEditor()).getText());
                        JavaCargoComputer.this.mo_MultiStopTableModel.setAvailableMoney(((PositiveSpinnerModel)JavaCargoComputer.this.mo_SprMoney.getModel()).getValueAsInt());
                    }
                    catch (Exception ex) {
                        JavaCargoComputer.this.mo_SprMoney.setValue(JavaCargoComputer.this.mo_SprMoney.getValue());
                    }
                }
            }
        });
        lo_TextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent ao_Event) {
                try {
                    JavaCargoComputer.this.mo_SprMoney.setValue(((JTextField)JavaCargoComputer.this.mo_SprMoney.getEditor()).getText());
                    JavaCargoComputer.this.mo_MultiStopTableModel.setAvailableMoney(((PositiveSpinnerModel)JavaCargoComputer.this.mo_SprMoney.getModel()).getValueAsInt());
                }
                catch (Exception ex) {
                    JavaCargoComputer.this.mo_SprMoney.setValue(JavaCargoComputer.this.mo_SprMoney.getValue());
                }
            }
        });
        this.mo_SprMoney.setEditor(lo_TextField);
        this.mo_SprMoney.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent ao_Event) {
                int li_SelectedRow = JavaCargoComputer.this.mo_TblTradeRoutes.getSelectedRow();
                if (li_SelectedRow != -1) {
                    JavaCargoComputer.this.mo_TblTradeRoutes.getSelectionModel().clearSelection();
                    JavaCargoComputer.this.mo_TblTradeRoutes.setRowSelectionInterval(li_SelectedRow, li_SelectedRow);
                    JavaCargoComputer.this.mo_MultiStopTableModel.setAvailableMoney(((PositiveSpinnerModel)JavaCargoComputer.this.mo_SprMoney.getModel()).getValueAsInt());
                }
                ((JTextField)JavaCargoComputer.this.mo_SprMoney.getEditor()).setText("$" + JavaCargoComputer.this.mo_SprMoney.getValue());
            }
        });
        this.setJMenuBar(this.mo_MnuMainMenu);
        this.getContentPane().setBackground(SystemColor.control);
        this.mo_ScrTradeRoutes.getViewport().setBackground(new Color(128, 128, 128));
        this.mo_ScrTradeRoutes.getVerticalScrollBar().setBackground(SystemColor.scrollbar);
        this.mo_ScrTradeRoutes.getHorizontalScrollBar().setBackground(SystemColor.scrollbar);
        this.mo_TblTradeRoutes.getTableHeader().setBackground(SystemColor.control);
        this.mo_TblTradeRoutes.getColumnModel().getColumn(2).setPreferredWidth(180);
        this.mo_TblTradeRoutes.getColumnModel().getColumn(2).setMaxWidth(180);
        this.mo_TblTradeRoutes.getColumnModel().getColumn(3).setMinWidth(60);
        this.mo_TblTradeRoutes.getColumnModel().getColumn(3).setMaxWidth(60);
        this.mo_TblTradeRoutes.getColumnModel().getColumn(4).setMinWidth(60);
        this.mo_TblTradeRoutes.getColumnModel().getColumn(4).setMaxWidth(60);
        this.mo_TblTradeRoutes.getColumnModel().getColumn(5).setMinWidth(60);
        this.mo_TblTradeRoutes.getColumnModel().getColumn(5).setMaxWidth(60);
        this.mo_TblTradeRoutes.getColumnModel().getColumn(6).setMinWidth(60);
        this.mo_TblTradeRoutes.getColumnModel().getColumn(6).setMaxWidth(60);
        this.mo_TblTradeRoutes.getColumnModel().getColumn(7).setMinWidth(90);
        this.mo_TblTradeRoutes.getColumnModel().getColumn(7).setMaxWidth(90);
        this.mo_TblTradeRoutes.setDefaultRenderer(class$java$lang$String == null ? (class$java$lang$String = JavaCargoComputer.class$("java.lang.String")) : class$java$lang$String, this.mo_CellRenderer);
        this.mo_TblTradeRoutes.setDefaultRenderer(class$java$lang$Integer == null ? (class$java$lang$Integer = JavaCargoComputer.class$("java.lang.Integer")) : class$java$lang$Integer, this.mo_CellRenderer);
        this.mo_TblTradeRoutes.setDefaultRenderer(class$java$lang$Short == null ? (class$java$lang$Short = JavaCargoComputer.class$("java.lang.Short")) : class$java$lang$Short, this.mo_CellRenderer);
        this.mo_TblTradeRoutes.setDefaultRenderer(class$java$lang$Double == null ? (class$java$lang$Double = JavaCargoComputer.class$("java.lang.Double")) : class$java$lang$Double, this.mo_CellRenderer);
        this.mo_TblTradeRoutes.setSelectionMode(0);
        this.mo_TblTradeRoutes.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent ao_Event) {
                if (!ao_Event.getValueIsAdjusting()) {
                    JavaCargoComputer.this.tradeRouteSelected();
                }
            }
        });
        this.mo_TblTradeRoutes.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent ao_Event) {
                boolean li_PreferredWidth = false;
                if (!JavaCargoComputer.this.mb_Sortable) {
                    return;
                }
                int li_TableColumnIndex = JavaCargoComputer.this.mo_TblTradeRoutes.getColumnModel().getColumnIndexAtX(ao_Event.getX());
                int li_ModelColumnIndex = JavaCargoComputer.this.mo_TblTradeRoutes.getColumnModel().getColumn(li_TableColumnIndex).getModelIndex();
                if (JavaCargoComputer.this.mo_TblTradeRoutes.getTableHeader().getCursor().getType() == 0) {
                    ((ITradeRouteTableModel)JavaCargoComputer.this.mo_TblTradeRoutes.getModel()).sortTable(li_ModelColumnIndex);
                }
            }
        });
        this.loadSettings();
        long ll_EndTime = System.currentTimeMillis();
        this.mo_LblStatus.setText("imported data in " + (ll_EndTime - ll_StartTime) + " ms");
    }

    private void saveSettings() {
        try {
            Properties lo_Properties = new Properties();
            lo_Properties.setProperty("Cargo", this.mo_SprCargo.getValue().toString());
            lo_Properties.setProperty("Money", this.mo_SprMoney.getValue().toString());
            lo_Properties.setProperty("HideFactions", String.valueOf(this.mo_Filter.hideFactions()));
            lo_Properties.setProperty("HideCommodities", String.valueOf(this.mo_Filter.hideCommodities()));
            lo_Properties.setProperty("HideLength", String.valueOf(this.mo_Filter.hideLength()));
            lo_Properties.setProperty("FactionsFilter", this.mo_Filter.getFactionsAsString());
            lo_Properties.setProperty("CommoditiesFilter", this.mo_Filter.getCommoditiesAsString());
            lo_Properties.setProperty("MaxTradeRouteLength", String.valueOf(this.mo_Filter.getMaxTradeRouteLength()));
            lo_Properties.setProperty("AutoSave", String.valueOf(this.mo_CbmAutoSave.isSelected()));
            lo_Properties.setProperty("SinglePlayer", String.valueOf(this.mo_RbmModeSinglePlayer.isSelected()));
            if (this.mo_RbmNormal.isSelected()) {
                lo_Properties.setProperty("mode", "one-stop");
            } else if (this.mo_RbmMultiStop.isSelected()) {
                lo_Properties.setProperty("mode", "multi-stop");
            } else {
                lo_Properties.setProperty("mode", "round-trip");
            }
            if (this.mo_CbbStart.getSelectedIndex() != -1) {
                lo_Properties.setProperty("start", this.mo_CbbStart.getSelectedItem().toString());
            }
            if (this.mo_CbbTarget.getSelectedIndex() != -1) {
                lo_Properties.setProperty("destination", this.mo_CbbTarget.getSelectedItem().toString());
            }
            lo_Properties.store(new FileOutputStream("JCCSettings.ini"), "JavaCargoComputer settings");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void loadSettings() {
        try {
            ITradePoint lo_TradePoint;
            Properties lo_Properties = new Properties();
            lo_Properties.load(new FileInputStream("JCCSettings.ini"));
            this.mo_SprCargo.setValue(lo_Properties.getProperty("Cargo", this.mo_SprCargo.getValue().toString()));
            this.mo_SprMoney.setValue(lo_Properties.getProperty("Money", this.mo_SprMoney.getValue().toString()));
            this.mo_Filter.setHideFactions(lo_Properties.getProperty("HideFactions", String.valueOf(this.mo_Filter.hideFactions())).equalsIgnoreCase("true"));
            this.mo_Filter.setHideCommodities(lo_Properties.getProperty("HideCommodities", String.valueOf(this.mo_Filter.hideCommodities())).equalsIgnoreCase("true"));
            this.mo_Filter.setHideLength(lo_Properties.getProperty("HideLength", String.valueOf(this.mo_Filter.hideLength())).equalsIgnoreCase("true"));
            this.mo_Filter.setFactionsAsString(lo_Properties.getProperty("FactionsFilter", this.mo_Filter.getFactionsAsString()));
            this.mo_Filter.setCommoditiesAsString(lo_Properties.getProperty("CommoditiesFilter", this.mo_Filter.getCommoditiesAsString()));
            this.mo_Filter.setMaxTradeRouteLength(Integer.parseInt(lo_Properties.getProperty("MaxTradeRouteLength", String.valueOf(this.mo_Filter.getMaxTradeRouteLength()))));
            this.mo_CbmAutoSave.setSelected(lo_Properties.getProperty("AutoSave", String.valueOf(this.mo_CbmAutoSave.isSelected())).equalsIgnoreCase("true"));
            String ls_RouteMode = lo_Properties.getProperty("mode");
            if (ls_RouteMode != null) {
                if (ls_RouteMode.equalsIgnoreCase("one-stop")) {
                    this.mo_RbmNormal.doClick();
                } else if (ls_RouteMode.equalsIgnoreCase("multi-stop")) {
                    this.mo_RbmMultiStop.doClick();
                } else if (ls_RouteMode.equalsIgnoreCase("round-trip")) {
                    this.mo_RbmRoundTrip.doClick();
                }
            }
            if (lo_Properties.getProperty("SinglePlayer") != null && lo_Properties.getProperty("SinglePlayer").equalsIgnoreCase("false")) {
                this.mo_RbmModeMultiPlayer.setSelected(true);
                this.mo_DataParser.setMapMode(1);
                this.mo_MapDialog.setTitle("Universe Map (Multi-Player)");
            } else {
                this.mo_RbmModeSinglePlayer.setSelected(true);
                this.mo_DataParser.setMapMode(0);
                this.mo_MapDialog.setTitle("Universe Map (Single-Player)");
            }
            String ls_TradePoint = lo_Properties.getProperty("start");
            if (ls_TradePoint != null) {
                lo_TradePoint = this.mo_DataParser.getTradePoint(ls_TradePoint);
                if (lo_TradePoint instanceof Base) {
                    this.mo_RBtnBaseStart.doClick();
                } else if (lo_TradePoint instanceof StarSystem) {
                    this.mo_RBtnSystemStart.doClick();
                } else if (lo_TradePoint instanceof Territory) {
                    this.mo_RBtnTerritoryStart.doClick();
                } else {
                    this.mo_RBtnUniverseStart.doClick();
                }
                this.mo_CbbStart.setSelectedItem(lo_TradePoint);
            }
            if ((ls_TradePoint = lo_Properties.getProperty("destination")) != null) {
                lo_TradePoint = this.mo_DataParser.getTradePoint(ls_TradePoint);
                if (lo_TradePoint instanceof Base) {
                    this.mo_RBtnBaseTarget.doClick();
                } else if (lo_TradePoint instanceof StarSystem) {
                    this.mo_RBtnSystemTarget.doClick();
                } else if (lo_TradePoint instanceof Territory) {
                    this.mo_RBtnTerritoryTarget.doClick();
                } else {
                    this.mo_RBtnUniverseTarget.doClick();
                }
                this.mo_CbbTarget.setSelectedItem(lo_TradePoint);
            }
            this.mo_CbmHideCommodities.setSelected(this.mo_Filter.hideCommodities());
            this.mo_CbmHideFactions.setSelected(this.mo_Filter.hideFactions());
            this.mo_CbmHideLength.setSelected(this.mo_Filter.hideLength());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void tradeRouteSelected() {
        int li_SelectedTradeRoute = this.mo_TblTradeRoutes.getSelectedRow();
        if (li_SelectedTradeRoute == -1) {
            this.mo_LblSelectedRouteDetails.setText("Select a trade route...");
            return;
        }
        this.mo_LblSelectedRouteDetails.setText(((ITradeRouteTableModel)this.mo_TblTradeRoutes.getModel()).getTradeRouteDetails(li_SelectedTradeRoute));
        if (this.mo_MultiStopTradeRouteDialog.isVisible() && this.mo_TblTradeRoutes.getModel() instanceof MultiStopTradeRouteTableModel) {
            this.mo_MultiStopTradeRouteDialog.setMultiStopTradeRoute((MultiStopTradeRoute)this.mo_MultiStopTableModel.getTradeRoute(li_SelectedTradeRoute));
        }
        TradeRoute lo_TradeRoute = ((ITradeRouteTableModel)this.mo_TblTradeRoutes.getModel()).getTradeRoute(li_SelectedTradeRoute);
        this.mo_MapDialog.setStart(this.mo_DataParser.getTradePoint(lo_TradeRoute.getStart()).toString());
        this.mo_MapDialog.setDestination(this.mo_DataParser.getTradePoint(lo_TradeRoute.getDestination()).toString());
        if (this.mo_MapDialog.isVisible()) {
            this.mo_MapDialog.updateMap();
        }
    }

    private void initComponents() {
        this.mo_BtnGrpStart = new ButtonGroup();
        this.mo_BtnGrpTarget = new ButtonGroup();
        this.mo_BtnGrpMapMode = new ButtonGroup();
        this.mo_BtnGrpTradeRouteMode = new ButtonGroup();
        this.mo_MnuMainMenu = new JMenuBar();
        this.mo_MnuFile = new JMenu();
        this.mo_MniLoadSettings = new JMenuItem();
        this.mo_MniSaveSettings = new JMenuItem();
        this.mo_CbmAutoSave = new JCheckBoxMenuItem();
        this.mo_MnuFilter = new JMenu();
        this.mo_MniSetFilter = new JMenuItem();
        this.jSeparator5 = new JSeparator();
        this.mo_CbmHideFactions = new JCheckBoxMenuItem();
        this.mo_CbmHideCommodities = new JCheckBoxMenuItem();
        this.mo_CbmHideLength = new JCheckBoxMenuItem();
        this.mo_MnuTradeRoutes = new JMenu();
        this.mo_RbmNormal = new JRadioButtonMenuItem();
        this.mo_RbmMultiStop = new JRadioButtonMenuItem();
        this.mo_RbmRoundTrip = new JRadioButtonMenuItem();
        this.mo_MnuMap = new JMenu();
        this.mo_MniShowMap = new JMenuItem();
        this.jSeparator4 = new JSeparator();
        this.mo_RbmModeSinglePlayer = new JRadioButtonMenuItem();
        this.mo_RbmModeMultiPlayer = new JRadioButtonMenuItem();
        this.mo_MnuShips = new JMenu();
        this.mo_MniShips = new JMenuItem();
        this.mo_PMnuTradeRoute = new JPopupMenu();
        this.mo_PnlStart = new JPanel();
        this.mo_RBtnBaseStart = new JRadioButton();
        this.mo_RBtnSystemStart = new JRadioButton();
        this.mo_RBtnTerritoryStart = new JRadioButton();
        this.mo_RBtnUniverseStart = new JRadioButton();
        this.mo_CbbStart = new JComboBox();
        this.mo_PnlSwitches = new JPanel();
        this.mo_BtnAdjustDestination = new JButton();
        this.mo_BtnSwitchLocations = new JButton();
        this.mo_BtnAdjustStart = new JButton();
        this.mo_PnlTarget = new JPanel();
        this.mo_RBtnBaseTarget = new JRadioButton();
        this.mo_RBtnSystemTarget = new JRadioButton();
        this.mo_RBtnTerritoryTarget = new JRadioButton();
        this.mo_RBtnUniverseTarget = new JRadioButton();
        this.mo_CbbTarget = new JComboBox();
        this.mo_LblMoney = new JLabel();
        this.mo_LblCargo = new JLabel();
        this.mo_SprMoney = new JSpinner();
        this.mo_SprCargo = new JSpinner();
        this.jSeparator1 = new JSeparator();
        this.jSeparator2 = new JSeparator();
        this.mo_ScrTradeRoutes = new JScrollPane();
        this.mo_TblTradeRoutes = new JTable();
        this.mo_PnlSelectedRoute = new JPanel();
        this.mo_LblSelectedRoute = new JLabel();
        this.mo_LblSelectedRouteDetails = new JLabel();
        this.jSeparator3 = new JSeparator();
        this.mo_BtnCalculate = new JButton();
        this.mo_PgbCalculation = new JProgressBar();
        this.mo_LblStatus = new JLabel();
        this.mo_BtnSelectBestRoute = new JButton();
        this.mo_MnuMainMenu.setBackground(SystemColor.menu);
        this.mo_MnuMainMenu.setFont(new Font("Dialog", 0, 12));
        this.mo_MnuFile.setBackground(SystemColor.menu);
        this.mo_MnuFile.setText("File");
        this.mo_MnuFile.setFont(new Font("Dialog", 0, 12));
        this.mo_MniLoadSettings.setBackground(SystemColor.menu);
        this.mo_MniLoadSettings.setFont(new Font("Dialog", 0, 12));
        this.mo_MniLoadSettings.setText("   Load Settings");
        this.mo_MniLoadSettings.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JavaCargoComputer.this.mo_MniLoadSettingsActionPerformed(evt);
            }
        });
        this.mo_MnuFile.add(this.mo_MniLoadSettings);
        this.mo_MniSaveSettings.setBackground(SystemColor.menu);
        this.mo_MniSaveSettings.setFont(new Font("Dialog", 0, 12));
        this.mo_MniSaveSettings.setText("   Save Settings");
        this.mo_MniSaveSettings.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JavaCargoComputer.this.mo_MniSaveSettingsActionPerformed(evt);
            }
        });
        this.mo_MnuFile.add(this.mo_MniSaveSettings);
        this.mo_CbmAutoSave.setBackground(SystemColor.menu);
        this.mo_CbmAutoSave.setFont(new Font("Dialog", 0, 12));
        this.mo_CbmAutoSave.setText("Save Settings On Exit");
        this.mo_MnuFile.add(this.mo_CbmAutoSave);
        this.mo_MnuMainMenu.add(this.mo_MnuFile);
        this.mo_MnuFilter.setBackground(SystemColor.menu);
        this.mo_MnuFilter.setText("Trade Route Filter");
        this.mo_MnuFilter.setFont(new Font("Dialog", 0, 12));
        this.mo_MniSetFilter.setBackground(SystemColor.menu);
        this.mo_MniSetFilter.setFont(new Font("Dialog", 0, 12));
        this.mo_MniSetFilter.setText("   Configure Filter");
        this.mo_MniSetFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JavaCargoComputer.this.mo_MniSetFilterActionPerformed(evt);
            }
        });
        this.mo_MnuFilter.add(this.mo_MniSetFilter);
        this.mo_MnuFilter.add(this.jSeparator5);
        this.mo_CbmHideFactions.setBackground(SystemColor.menu);
        this.mo_CbmHideFactions.setFont(new Font("Dialog", 0, 12));
        this.mo_CbmHideFactions.setText("Hide Selected Factions");
        this.mo_CbmHideFactions.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JavaCargoComputer.this.mo_CbmHideFactionsActionPerformed(evt);
            }
        });
        this.mo_MnuFilter.add(this.mo_CbmHideFactions);
        this.mo_CbmHideCommodities.setBackground(SystemColor.menu);
        this.mo_CbmHideCommodities.setFont(new Font("Dialog", 0, 12));
        this.mo_CbmHideCommodities.setText("Hide Selected Commodities");
        this.mo_CbmHideCommodities.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JavaCargoComputer.this.mo_CbmHideCommoditiesActionPerformed(evt);
            }
        });
        this.mo_MnuFilter.add(this.mo_CbmHideCommodities);
        this.mo_CbmHideLength.setBackground(SystemColor.menu);
        this.mo_CbmHideLength.setFont(new Font("Dialog", 0, 12));
        this.mo_CbmHideLength.setText("Apply Length Setting");
        this.mo_CbmHideLength.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JavaCargoComputer.this.mo_CbmHideLengthActionPerformed(evt);
            }
        });
        this.mo_MnuFilter.add(this.mo_CbmHideLength);
        this.mo_MnuMainMenu.add(this.mo_MnuFilter);
        this.mo_MnuTradeRoutes.setBackground(SystemColor.menu);
        this.mo_MnuTradeRoutes.setText("Trade Routes");
        this.mo_MnuTradeRoutes.setFont(new Font("Dialog", 0, 12));
        this.mo_RbmNormal.setBackground(SystemColor.menu);
        this.mo_RbmNormal.setFont(new Font("Dialog", 0, 12));
        this.mo_RbmNormal.setText("One-Stop-Routes");
        this.mo_BtnGrpTradeRouteMode.add(this.mo_RbmNormal);
        this.mo_RbmNormal.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JavaCargoComputer.this.mo_RbmNormalActionPerformed(evt);
            }
        });
        this.mo_MnuTradeRoutes.add(this.mo_RbmNormal);
        this.mo_RbmMultiStop.setBackground(SystemColor.menu);
        this.mo_RbmMultiStop.setFont(new Font("Dialog", 0, 12));
        this.mo_RbmMultiStop.setText("Multi-Stop-Routes");
        this.mo_BtnGrpTradeRouteMode.add(this.mo_RbmMultiStop);
        this.mo_RbmMultiStop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JavaCargoComputer.this.mo_RbmMultiStopActionPerformed(evt);
            }
        });
        this.mo_MnuTradeRoutes.add(this.mo_RbmMultiStop);
        this.mo_RbmRoundTrip.setBackground(SystemColor.menu);
        this.mo_RbmRoundTrip.setFont(new Font("Dialog", 0, 12));
        this.mo_RbmRoundTrip.setText("Round-Trip-Routes");
        this.mo_BtnGrpTradeRouteMode.add(this.mo_RbmRoundTrip);
        this.mo_RbmRoundTrip.setEnabled(false);
        this.mo_RbmRoundTrip.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JavaCargoComputer.this.mo_RbmRoundTripActionPerformed(evt);
            }
        });
        this.mo_MnuTradeRoutes.add(this.mo_RbmRoundTrip);
        this.mo_MnuMainMenu.add(this.mo_MnuTradeRoutes);
        this.mo_MnuMap.setBackground(SystemColor.menu);
        this.mo_MnuMap.setText("Map");
        this.mo_MnuMap.setFont(new Font("Dialog", 0, 12));
        this.mo_MniShowMap.setBackground(SystemColor.menu);
        this.mo_MniShowMap.setFont(new Font("Dialog", 0, 12));
        this.mo_MniShowMap.setText("   Show Map");
        this.mo_MniShowMap.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JavaCargoComputer.this.mo_MniShowMapActionPerformed(evt);
            }
        });
        this.mo_MnuMap.add(this.mo_MniShowMap);
        this.mo_MnuMap.add(this.jSeparator4);
        this.mo_RbmModeSinglePlayer.setBackground(SystemColor.menu);
        this.mo_RbmModeSinglePlayer.setFont(new Font("Dialog", 0, 12));
        this.mo_RbmModeSinglePlayer.setText("Single-Player Map");
        this.mo_BtnGrpMapMode.add(this.mo_RbmModeSinglePlayer);
        this.mo_RbmModeSinglePlayer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JavaCargoComputer.this.mo_RbmModeSinglePlayerActionPerformed(evt);
            }
        });
        this.mo_MnuMap.add(this.mo_RbmModeSinglePlayer);
        this.mo_RbmModeMultiPlayer.setBackground(SystemColor.menu);
        this.mo_RbmModeMultiPlayer.setFont(new Font("Dialog", 0, 12));
        this.mo_RbmModeMultiPlayer.setText("Multi-Player Map");
        this.mo_BtnGrpMapMode.add(this.mo_RbmModeMultiPlayer);
        this.mo_RbmModeMultiPlayer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JavaCargoComputer.this.mo_RbmModeMultiPlayerActionPerformed(evt);
            }
        });
        this.mo_MnuMap.add(this.mo_RbmModeMultiPlayer);
        this.mo_MnuMainMenu.add(this.mo_MnuMap);
        this.mo_MnuShips.setBackground(SystemColor.menu);
        this.mo_MnuShips.setText("Ships");
        this.mo_MnuShips.setFont(new Font("Dialog", 0, 12));
        this.mo_MniShips.setBackground(SystemColor.menu);
        this.mo_MniShips.setFont(new Font("Dialog", 0, 12));
        this.mo_MniShips.setText("Show Ships");
        this.mo_MniShips.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JavaCargoComputer.this.mo_MniShipsActionPerformed(evt);
            }
        });
        this.mo_MnuShips.add(this.mo_MniShips);
        this.mo_MnuMainMenu.add(this.mo_MnuShips);
        this.mo_PMnuTradeRoute.setBackground(SystemColor.menu);
        this.mo_PMnuTradeRoute.setFont(new Font("Dialog", 0, 12));
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Java Cargo Computer [One-Stop-Trade-Routes]");
        this.setBackground(SystemColor.activeCaptionBorder);
        this.setIconImage(new ImageIcon(this.getClass().getResource("/freelancer/images/icon32.GIF")).getImage());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                JavaCargoComputer.this.exitForm(evt);
            }
        });
        this.mo_PnlStart.setLayout(new GridBagLayout());
        this.mo_PnlStart.setBorder(new TitledBorder(new EtchedBorder(), " Start ", 0, 0, new Font("Dialog", 0, 12)));
        this.mo_PnlStart.setMinimumSize(new Dimension(400, 120));
        this.mo_PnlStart.setPreferredSize(new Dimension(400, 120));
        this.mo_PnlStart.setOpaque(false);
        this.mo_RBtnBaseStart.setBackground(SystemColor.control);
        this.mo_RBtnBaseStart.setFont(new Font("Dialog", 0, 12));
        this.mo_RBtnBaseStart.setText("Base");
        this.mo_BtnGrpStart.add(this.mo_RBtnBaseStart);
        this.mo_RBtnBaseStart.setOpaque(false);
        this.mo_RBtnBaseStart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JavaCargoComputer.this.mo_RBtnBaseStartActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mo_PnlStart.add((Component)this.mo_RBtnBaseStart, gridBagConstraints);
        this.mo_RBtnSystemStart.setBackground(SystemColor.control);
        this.mo_RBtnSystemStart.setFont(new Font("Dialog", 0, 12));
        this.mo_RBtnSystemStart.setText("System");
        this.mo_BtnGrpStart.add(this.mo_RBtnSystemStart);
        this.mo_RBtnSystemStart.setOpaque(false);
        this.mo_RBtnSystemStart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JavaCargoComputer.this.mo_RBtnSystemStartActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mo_PnlStart.add((Component)this.mo_RBtnSystemStart, gridBagConstraints);
        this.mo_RBtnTerritoryStart.setBackground(SystemColor.control);
        this.mo_RBtnTerritoryStart.setFont(new Font("Dialog", 0, 12));
        this.mo_RBtnTerritoryStart.setText("Territory");
        this.mo_BtnGrpStart.add(this.mo_RBtnTerritoryStart);
        this.mo_RBtnTerritoryStart.setOpaque(false);
        this.mo_RBtnTerritoryStart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JavaCargoComputer.this.mo_RBtnTerritoryStartActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mo_PnlStart.add((Component)this.mo_RBtnTerritoryStart, gridBagConstraints);
        this.mo_RBtnUniverseStart.setBackground(SystemColor.control);
        this.mo_RBtnUniverseStart.setFont(new Font("Dialog", 0, 12));
        this.mo_RBtnUniverseStart.setText("Universe");
        this.mo_BtnGrpStart.add(this.mo_RBtnUniverseStart);
        this.mo_RBtnUniverseStart.setOpaque(false);
        this.mo_RBtnUniverseStart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JavaCargoComputer.this.mo_RBtnUniverseStartActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mo_PnlStart.add((Component)this.mo_RBtnUniverseStart, gridBagConstraints);
        this.mo_CbbStart.setBackground(SystemColor.control);
        this.mo_CbbStart.setFont(new Font("Dialog", 0, 12));
        this.mo_CbbStart.setMinimumSize(new Dimension(400, 25));
        this.mo_CbbStart.setPreferredSize(new Dimension(400, 25));
        this.mo_CbbStart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JavaCargoComputer.this.mo_CbbStartActionPerformed(evt);
            }
        });
        this.mo_CbbStart.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                JavaCargoComputer.this.mo_CbbStartPopupMenuWillBecomeVisible(evt);
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
                JavaCargoComputer.this.mo_CbbStartPopupMenuWillBecomeInvisible(evt);
            }

            public void popupMenuCanceled(PopupMenuEvent evt) {
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mo_PnlStart.add((Component)this.mo_CbbStart, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.mo_PnlStart, gridBagConstraints);
        this.mo_PnlSwitches.setLayout(new GridBagLayout());
        this.mo_PnlSwitches.setOpaque(false);
        this.mo_BtnAdjustDestination.setBackground(SystemColor.control);
        this.mo_BtnAdjustDestination.setFont(new Font("Dialog", 0, 12));
        this.mo_BtnAdjustDestination.setText(">");
        this.mo_BtnAdjustDestination.setToolTipText("Adjust Destination to match Start");
        this.mo_BtnAdjustDestination.setMaximumSize(new Dimension(51, 23));
        this.mo_BtnAdjustDestination.setMinimumSize(new Dimension(51, 23));
        this.mo_BtnAdjustDestination.setPreferredSize(new Dimension(51, 23));
        this.mo_BtnAdjustDestination.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JavaCargoComputer.this.mo_BtnAdjustDestinationActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mo_PnlSwitches.add((Component)this.mo_BtnAdjustDestination, gridBagConstraints);
        this.mo_BtnSwitchLocations.setBackground(SystemColor.control);
        this.mo_BtnSwitchLocations.setFont(new Font("Dialog", 0, 12));
        this.mo_BtnSwitchLocations.setText("< >");
        this.mo_BtnSwitchLocations.setToolTipText("Swap Start and Destination");
        this.mo_BtnSwitchLocations.setMaximumSize(new Dimension(51, 23));
        this.mo_BtnSwitchLocations.setMinimumSize(new Dimension(51, 23));
        this.mo_BtnSwitchLocations.setPreferredSize(new Dimension(51, 23));
        this.mo_BtnSwitchLocations.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JavaCargoComputer.this.mo_BtnSwitchLocationsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mo_PnlSwitches.add((Component)this.mo_BtnSwitchLocations, gridBagConstraints);
        this.mo_BtnAdjustStart.setBackground(SystemColor.control);
        this.mo_BtnAdjustStart.setFont(new Font("Dialog", 0, 12));
        this.mo_BtnAdjustStart.setText("<");
        this.mo_BtnAdjustStart.setToolTipText("Adjust Start to match Destination");
        this.mo_BtnAdjustStart.setMaximumSize(new Dimension(51, 23));
        this.mo_BtnAdjustStart.setMinimumSize(new Dimension(51, 23));
        this.mo_BtnAdjustStart.setPreferredSize(new Dimension(51, 23));
        this.mo_BtnAdjustStart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JavaCargoComputer.this.mo_BtnAdjustStartActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mo_PnlSwitches.add((Component)this.mo_BtnAdjustStart, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.mo_PnlSwitches, gridBagConstraints);
        this.mo_PnlTarget.setLayout(new GridBagLayout());
        this.mo_PnlTarget.setBorder(new TitledBorder(new EtchedBorder(), " Destination ", 0, 0, new Font("Dialog", 0, 12)));
        this.mo_PnlTarget.setMinimumSize(new Dimension(400, 120));
        this.mo_PnlTarget.setPreferredSize(new Dimension(400, 120));
        this.mo_PnlTarget.setOpaque(false);
        this.mo_RBtnBaseTarget.setBackground(SystemColor.control);
        this.mo_RBtnBaseTarget.setFont(new Font("Dialog", 0, 12));
        this.mo_RBtnBaseTarget.setText("Base");
        this.mo_BtnGrpTarget.add(this.mo_RBtnBaseTarget);
        this.mo_RBtnBaseTarget.setOpaque(false);
        this.mo_RBtnBaseTarget.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JavaCargoComputer.this.mo_RBtnBaseTargetActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mo_PnlTarget.add((Component)this.mo_RBtnBaseTarget, gridBagConstraints);
        this.mo_RBtnSystemTarget.setBackground(SystemColor.control);
        this.mo_RBtnSystemTarget.setFont(new Font("Dialog", 0, 12));
        this.mo_RBtnSystemTarget.setText("System");
        this.mo_BtnGrpTarget.add(this.mo_RBtnSystemTarget);
        this.mo_RBtnSystemTarget.setOpaque(false);
        this.mo_RBtnSystemTarget.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JavaCargoComputer.this.mo_RBtnSystemTargetActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mo_PnlTarget.add((Component)this.mo_RBtnSystemTarget, gridBagConstraints);
        this.mo_RBtnTerritoryTarget.setBackground(SystemColor.control);
        this.mo_RBtnTerritoryTarget.setFont(new Font("Dialog", 0, 12));
        this.mo_RBtnTerritoryTarget.setText("Territory");
        this.mo_BtnGrpTarget.add(this.mo_RBtnTerritoryTarget);
        this.mo_RBtnTerritoryTarget.setOpaque(false);
        this.mo_RBtnTerritoryTarget.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JavaCargoComputer.this.mo_RBtnTerritoryTargetActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mo_PnlTarget.add((Component)this.mo_RBtnTerritoryTarget, gridBagConstraints);
        this.mo_RBtnUniverseTarget.setBackground(SystemColor.control);
        this.mo_RBtnUniverseTarget.setFont(new Font("Dialog", 0, 12));
        this.mo_RBtnUniverseTarget.setText("Universe");
        this.mo_BtnGrpTarget.add(this.mo_RBtnUniverseTarget);
        this.mo_RBtnUniverseTarget.setOpaque(false);
        this.mo_RBtnUniverseTarget.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JavaCargoComputer.this.mo_RBtnUniverseTargetActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mo_PnlTarget.add((Component)this.mo_RBtnUniverseTarget, gridBagConstraints);
        this.mo_CbbTarget.setBackground(SystemColor.control);
        this.mo_CbbTarget.setFont(new Font("Dialog", 0, 12));
        this.mo_CbbTarget.setMinimumSize(new Dimension(400, 25));
        this.mo_CbbTarget.setPreferredSize(new Dimension(400, 25));
        this.mo_CbbTarget.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                JavaCargoComputer.this.mo_CbbTargetPopupMenuWillBecomeVisible(evt);
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
                JavaCargoComputer.this.mo_CbbTargetPopupMenuWillBecomeInvisible(evt);
            }

            public void popupMenuCanceled(PopupMenuEvent evt) {
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mo_PnlTarget.add((Component)this.mo_CbbTarget, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.mo_PnlTarget, gridBagConstraints);
        this.mo_LblMoney.setFont(new Font("Dialog", 0, 12));
        this.mo_LblMoney.setText("Available Money");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.getContentPane().add((Component)this.mo_LblMoney, gridBagConstraints);
        this.mo_LblCargo.setFont(new Font("Dialog", 0, 12));
        this.mo_LblCargo.setText("Available Cargo Space");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.getContentPane().add((Component)this.mo_LblCargo, gridBagConstraints);
        this.mo_SprMoney.setBackground(SystemColor.control);
        this.mo_SprMoney.setFont(new Font("Dialog", 0, 12));
        this.mo_SprMoney.setForeground(SystemColor.control);
        this.mo_SprMoney.setDoubleBuffered(true);
        this.mo_SprMoney.setModel(new PositiveSpinnerModel(100));
        this.mo_SprMoney.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.mo_SprMoney, gridBagConstraints);
        this.mo_SprCargo.setBackground(SystemColor.control);
        this.mo_SprCargo.setFont(new Font("Dialog", 0, 12));
        this.mo_SprCargo.setDoubleBuffered(true);
        this.mo_SprCargo.setModel(new PositiveSpinnerModel());
        this.mo_SprCargo.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.mo_SprCargo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.getContentPane().add((Component)this.jSeparator2, gridBagConstraints);
        this.mo_ScrTradeRoutes.setBackground(SystemColor.control);
        this.mo_ScrTradeRoutes.setVerticalScrollBarPolicy(22);
        this.mo_TblTradeRoutes.setModel(this.mo_TableModel);
        this.mo_TblTradeRoutes.setAutoResizeMode(4);
        this.mo_TblTradeRoutes.setDoubleBuffered(true);
        this.mo_TblTradeRoutes.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                JavaCargoComputer.this.mo_TblTradeRoutesMouseClicked(evt);
            }
        });
        this.mo_ScrTradeRoutes.setViewportView(this.mo_TblTradeRoutes);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.mo_ScrTradeRoutes, gridBagConstraints);
        this.mo_PnlSelectedRoute.setLayout(new GridBagLayout());
        this.mo_PnlSelectedRoute.setOpaque(false);
        this.mo_LblSelectedRoute.setFont(new Font("Dialog", 0, 12));
        this.mo_LblSelectedRoute.setText("Selected Trade Route");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.mo_PnlSelectedRoute.add((Component)this.mo_LblSelectedRoute, gridBagConstraints);
        this.mo_LblSelectedRouteDetails.setFont(new Font("Dialog", 0, 12));
        this.mo_LblSelectedRouteDetails.setHorizontalAlignment(11);
        this.mo_LblSelectedRouteDetails.setText("Select a trade route...");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.mo_PnlSelectedRoute.add((Component)this.mo_LblSelectedRouteDetails, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.mo_PnlSelectedRoute, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.getContentPane().add((Component)this.jSeparator3, gridBagConstraints);
        this.mo_BtnCalculate.setFont(new Font("Dialog", 0, 12));
        this.mo_BtnCalculate.setText("Calculate Trade Routes");
        this.mo_BtnCalculate.setBorder(new BevelBorder(0));
        this.mo_BtnCalculate.setMaximumSize(new Dimension(200, 23));
        this.mo_BtnCalculate.setMinimumSize(new Dimension(200, 23));
        this.mo_BtnCalculate.setPreferredSize(new Dimension(200, 23));
        this.mo_BtnCalculate.setOpaque(false);
        this.mo_BtnCalculate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JavaCargoComputer.this.mo_BtnCalculateActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.mo_BtnCalculate, gridBagConstraints);
        this.mo_PgbCalculation.setBackground(SystemColor.control);
        this.mo_PgbCalculation.setForeground(new Color(0, 0, 128));
        this.mo_PgbCalculation.setMaximumSize(new Dimension(319, 15));
        this.mo_PgbCalculation.setMinimumSize(new Dimension(319, 15));
        this.mo_PgbCalculation.setPreferredSize(new Dimension(319, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(7, 5, 3, 8);
        this.getContentPane().add((Component)this.mo_PgbCalculation, gridBagConstraints);
        this.mo_LblStatus.setBackground(SystemColor.control);
        this.mo_LblStatus.setFont(new Font("Dialog", 0, 12));
        this.mo_LblStatus.setText("Select Start and Target then click 'Calculate Trade Routes'");
        this.mo_LblStatus.setBorder(new EtchedBorder());
        this.mo_LblStatus.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this.mo_LblStatus, gridBagConstraints);
        this.mo_BtnSelectBestRoute.setFont(new Font("Dialog", 0, 12));
        this.mo_BtnSelectBestRoute.setText("Select Best Trade Route");
        this.mo_BtnSelectBestRoute.setBorder(new BevelBorder(0));
        this.mo_BtnSelectBestRoute.setMaximumSize(new Dimension(200, 23));
        this.mo_BtnSelectBestRoute.setMinimumSize(new Dimension(200, 23));
        this.mo_BtnSelectBestRoute.setPreferredSize(new Dimension(200, 23));
        this.mo_BtnSelectBestRoute.setOpaque(false);
        this.mo_BtnSelectBestRoute.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JavaCargoComputer.this.mo_BtnSelectBestRouteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.mo_BtnSelectBestRoute, gridBagConstraints);
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(new Dimension(800, 600));
        this.setLocation((screenSize.width - 800) / 2, (screenSize.height - 600) / 2);
    }

    private void mo_CbbTargetPopupMenuWillBecomeVisible(PopupMenuEvent evt) {
        this.mo_Destination = this.mo_CbbTarget.getSelectedItem();
    }

    private void mo_CbbTargetPopupMenuWillBecomeInvisible(PopupMenuEvent evt) {
        if (!this.mo_Destination.equals(this.mo_CbbTarget.getSelectedItem())) {
            this.mo_BtnCalculate.doClick();
        }
    }

    private void mo_CbbStartPopupMenuWillBecomeVisible(PopupMenuEvent evt) {
        this.mo_Start = this.mo_CbbStart.getSelectedItem();
    }

    private void mo_CbbStartPopupMenuWillBecomeInvisible(PopupMenuEvent evt) {
        if (!this.mo_Start.equals(this.mo_CbbStart.getSelectedItem())) {
            this.mo_BtnCalculate.doClick();
        }
    }

    private void mo_CbbStartActionPerformed(ActionEvent evt) {
    }

    private void mo_RbmRoundTripActionPerformed(ActionEvent evt) {
        if (this.mi_TradeRouteMode != 2) {
            this.mi_TradeRouteMode = 2;
            this.mo_Filter.setMode(2);
            this.setTitle("Java Cargo Computer [Round-Trip-Trade-Routes]");
        }
    }

    private void mo_RbmMultiStopActionPerformed(ActionEvent evt) {
        if (this.mi_TradeRouteMode != 1) {
            this.mo_BtnSelectBestRoute.setEnabled(false);
            this.mi_TradeRouteMode = 1;
            this.mo_Filter.setMode(1);
            this.mo_TblTradeRoutes.setModel(this.mo_MultiStopTableModel);
            this.mo_MultiStopTableModel.setAvailableCargo(((PositiveSpinnerModel)this.mo_SprCargo.getModel()).getValueAsInt());
            this.mo_MultiStopTableModel.setAvailableMoney(((PositiveSpinnerModel)this.mo_SprMoney.getModel()).getValueAsInt());
            this.mo_TblTradeRoutes.getColumnModel().getColumn(2).setMaxWidth(100);
            this.mo_TblTradeRoutes.getColumnModel().getColumn(2).setMaxWidth(100);
            this.mo_TblTradeRoutes.getColumnModel().getColumn(3).setMinWidth(60);
            this.mo_TblTradeRoutes.getColumnModel().getColumn(3).setMaxWidth(60);
            this.mo_TblTradeRoutes.getColumnModel().getColumn(4).setMinWidth(60);
            this.mo_TblTradeRoutes.getColumnModel().getColumn(4).setMaxWidth(60);
            this.mo_TblTradeRoutes.getColumnModel().getColumn(5).setMinWidth(90);
            this.mo_TblTradeRoutes.getColumnModel().getColumn(5).setMaxWidth(90);
            this.setTitle("Java Cargo Computer [Multi-Stop-Trade-Routes]");
        }
    }

    private void mo_RbmNormalActionPerformed(ActionEvent evt) {
        if (this.mi_TradeRouteMode != 0) {
            this.mo_BtnSelectBestRoute.setEnabled(true);
            this.mi_TradeRouteMode = 0;
            this.mo_Filter.setMode(0);
            this.mo_TblTradeRoutes.setModel(this.mo_TableModel);
            this.mo_TblTradeRoutes.getColumnModel().getColumn(2).setPreferredWidth(180);
            this.mo_TblTradeRoutes.getColumnModel().getColumn(2).setMaxWidth(180);
            this.mo_TblTradeRoutes.getColumnModel().getColumn(3).setMinWidth(60);
            this.mo_TblTradeRoutes.getColumnModel().getColumn(3).setMaxWidth(60);
            this.mo_TblTradeRoutes.getColumnModel().getColumn(4).setMinWidth(60);
            this.mo_TblTradeRoutes.getColumnModel().getColumn(4).setMaxWidth(60);
            this.mo_TblTradeRoutes.getColumnModel().getColumn(5).setMinWidth(60);
            this.mo_TblTradeRoutes.getColumnModel().getColumn(5).setMaxWidth(60);
            this.mo_TblTradeRoutes.getColumnModel().getColumn(6).setMinWidth(60);
            this.mo_TblTradeRoutes.getColumnModel().getColumn(6).setMaxWidth(60);
            this.mo_TblTradeRoutes.getColumnModel().getColumn(7).setMinWidth(90);
            this.mo_TblTradeRoutes.getColumnModel().getColumn(7).setMaxWidth(90);
            this.setTitle("Java Cargo Computer [One-Stop-Trade-Routes]");
        }
    }

    private void mo_CbmHideLengthActionPerformed(ActionEvent evt) {
        this.mo_Filter.setHideLength(this.mo_CbmHideLength.isSelected());
        System.out.println("setting length restriction to " + this.mo_Filter.hideLength());
        System.out.println("max length is " + this.mo_Filter.getMaxTradeRouteLength());
        this.mo_BtnCalculate.doClick();
    }

    private void mo_TblTradeRoutesMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 3) {
            int li_TableColumnIndex = this.mo_TblTradeRoutes.getColumnModel().getColumnIndexAtX(evt.getX());
            int li_ModelColumnIndex = this.mo_TblTradeRoutes.getColumnModel().getColumn(li_TableColumnIndex).getModelIndex();
            int li_SelectedRow = evt.getY() / this.mo_TblTradeRoutes.getRowHeight();
            this.mo_TblTradeRoutes.setRowSelectionInterval(li_SelectedRow, li_SelectedRow);
            ((ITradeRouteTableModel)this.mo_TblTradeRoutes.getModel()).showContextMenu(li_SelectedRow, li_ModelColumnIndex, evt.getX(), evt.getY());
        }
    }

    private void mo_BtnSwitchLocationsActionPerformed(ActionEvent evt) {
        int li_StartMode = -1;
        int li_DestinationMode = -1;
        int li_StartIndex = this.mo_CbbStart.getSelectedIndex();
        int li_DestinationIndex = this.mo_CbbTarget.getSelectedIndex();
        if (this.mo_RBtnBaseTarget.isSelected()) {
            li_DestinationMode = 0;
        } else if (this.mo_RBtnSystemTarget.isSelected()) {
            li_DestinationMode = 1;
        } else if (this.mo_RBtnTerritoryTarget.isSelected()) {
            li_DestinationMode = 2;
        } else if (this.mo_RBtnUniverseTarget.isSelected()) {
            li_DestinationMode = 3;
        }
        if (this.mo_RBtnBaseStart.isSelected()) {
            li_StartMode = 0;
        } else if (this.mo_RBtnSystemStart.isSelected()) {
            li_StartMode = 1;
        } else if (this.mo_RBtnTerritoryStart.isSelected()) {
            li_StartMode = 2;
        } else if (this.mo_RBtnUniverseStart.isSelected()) {
            li_StartMode = 3;
        }
        switch (li_StartMode) {
            case 0: {
                this.mo_RBtnBaseTarget.doClick();
                break;
            }
            case 1: {
                this.mo_RBtnSystemTarget.doClick();
                break;
            }
            case 2: {
                this.mo_RBtnTerritoryTarget.doClick();
                break;
            }
            case 3: {
                this.mo_RBtnUniverseTarget.doClick();
            }
        }
        switch (li_DestinationMode) {
            case 0: {
                this.mo_RBtnBaseStart.doClick();
                break;
            }
            case 1: {
                this.mo_RBtnSystemStart.doClick();
                break;
            }
            case 2: {
                this.mo_RBtnTerritoryStart.doClick();
                break;
            }
            case 3: {
                this.mo_RBtnUniverseStart.doClick();
            }
        }
        this.mo_CbbStart.setSelectedIndex(li_DestinationIndex);
        this.mo_CbbTarget.setSelectedIndex(li_StartIndex);
    }

    private void mo_BtnAdjustStartActionPerformed(ActionEvent evt) {
        if (this.mo_RBtnBaseTarget.isSelected()) {
            this.mo_RBtnBaseStart.doClick();
        } else if (this.mo_RBtnSystemTarget.isSelected()) {
            this.mo_RBtnSystemStart.doClick();
        } else if (this.mo_RBtnTerritoryTarget.isSelected()) {
            this.mo_RBtnTerritoryStart.doClick();
        } else if (this.mo_RBtnUniverseTarget.isSelected()) {
            this.mo_RBtnUniverseStart.doClick();
        }
        this.mo_CbbStart.setSelectedIndex(this.mo_CbbTarget.getSelectedIndex());
    }

    private void mo_BtnAdjustDestinationActionPerformed(ActionEvent evt) {
        if (this.mo_RBtnBaseStart.isSelected()) {
            this.mo_RBtnBaseTarget.doClick();
        } else if (this.mo_RBtnSystemStart.isSelected()) {
            this.mo_RBtnSystemTarget.doClick();
        } else if (this.mo_RBtnTerritoryStart.isSelected()) {
            this.mo_RBtnTerritoryTarget.doClick();
        } else if (this.mo_RBtnUniverseStart.isSelected()) {
            this.mo_RBtnUniverseTarget.doClick();
        }
        this.mo_CbbTarget.setSelectedIndex(this.mo_CbbStart.getSelectedIndex());
    }

    private void mo_RbmModeMultiPlayerActionPerformed(ActionEvent evt) {
        this.mo_DataParser.setMapMode(1);
        this.mo_DataParser.clearCache();
        this.mo_MapDialog.updateMap();
        this.mo_MapDialog.setTitle("Universe Map (Multi-Player)");
    }

    private void mo_RbmModeSinglePlayerActionPerformed(ActionEvent evt) {
        this.mo_DataParser.setMapMode(0);
        this.mo_DataParser.clearCache();
        this.mo_MapDialog.updateMap();
        this.mo_MapDialog.setTitle("Universe Map (Single-Player)");
    }

    private void mo_MniShipsActionPerformed(ActionEvent evt) {
    }

    private void mo_MniShowMapActionPerformed(ActionEvent evt) {
        this.mo_MapDialog.show();
        this.mo_MapDialog.updateMap();
    }

    private void mo_CbmHideCommoditiesActionPerformed(ActionEvent evt) {
        this.mo_Filter.setHideCommodities(this.mo_CbmHideCommodities.isSelected());
        this.mo_BtnCalculate.doClick();
    }

    private void mo_MniLoadSettingsActionPerformed(ActionEvent evt) {
        this.loadSettings();
    }

    private void mo_MniSaveSettingsActionPerformed(ActionEvent evt) {
        this.saveSettings();
    }

    private void mo_MniSetFilterActionPerformed(ActionEvent evt) {
        FilterDialog lo_FilterDialog = new FilterDialog((Frame)this, true);
        lo_FilterDialog.setAvailableFactions(this.mo_DataParser.getFactions());
        lo_FilterDialog.setSelectedFactions(this.mo_Filter.getFactions());
        lo_FilterDialog.setAvailableCommodities(this.mo_DataParser.getCommodities());
        lo_FilterDialog.setSelectedCommodities(this.mo_Filter.getCommodities());
        lo_FilterDialog.setTradeRouteLength(this.mo_Filter.getMaxTradeRouteLength());
        lo_FilterDialog.show();
        if (lo_FilterDialog.selectedOK()) {
            this.mo_Filter.setFactions(lo_FilterDialog.getSelectedFactions());
            this.mo_Filter.setCommodities(lo_FilterDialog.getSelectedCommodities());
            this.mo_Filter.setMaxTradeRouteLength(lo_FilterDialog.getTradeRouteLength());
            if (this.mo_Filter.hideFactions() || this.mo_Filter.hideCommodities() || this.mo_Filter.hideLength()) {
                this.mo_DataParser.clearCache();
                this.mo_BtnCalculate.doClick();
            } else {
                this.mo_TblTradeRoutes.repaint();
            }
        }
    }

    private void mo_CbmHideFactionsActionPerformed(ActionEvent evt) {
        this.mo_Filter.setHideFactions(this.mo_CbmHideFactions.isSelected());
        this.mo_BtnCalculate.doClick();
    }

    private void mo_BtnSelectBestRouteActionPerformed(ActionEvent evt) {
        boolean li_MaxProfit = false;
        int li_Index = -1;
        int li_AvailableCargo = ((PositiveSpinnerModel)this.mo_SprCargo.getModel()).getValueAsInt();
        int li_AvailableMoney = ((PositiveSpinnerModel)this.mo_SprMoney.getModel()).getValueAsInt();
        this.mo_TblTradeRoutes.getSelectionModel().clearSelection();
        li_Index = this.mo_DataParser.getBestTradeRoute(((ITradeRouteTableModel)this.mo_TblTradeRoutes.getModel()).getTradeRoutes(), li_AvailableMoney, li_AvailableCargo);
        if (li_Index != 1) {
            this.mo_LblSelectedRouteDetails.setText(((ITradeRouteTableModel)this.mo_TblTradeRoutes.getModel()).getTradeRouteDetails(li_Index));
            this.mo_TblTradeRoutes.setRowSelectionInterval(li_Index, li_Index);
            this.mo_TblTradeRoutes.scrollRectToVisible(new Rectangle(0, this.mo_TblTradeRoutes.getRowHeight() * li_Index - this.mo_ScrTradeRoutes.getHeight() / 2, this.mo_ScrTradeRoutes.getWidth(), this.mo_ScrTradeRoutes.getHeight()));
        }
        this.mo_TblTradeRoutes.requestFocus();
    }

    private void mo_BtnCalculateActionPerformed(ActionEvent evt) {
        if (this.mo_CalculationThread == null) {
            this.mo_LblStatus.setText("calculating trade routes - please wait...");
            if (this.mo_CbbStart.getSelectedIndex() == -1) {
                this.mo_LblStatus.setText("no start selected...");
                return;
            }
            if (this.mo_CbbTarget.getSelectedIndex() == -1) {
                this.mo_LblStatus.setText("no target selected...");
                return;
            }
            this.mo_BtnCalculate.setEnabled(false);
            this.mo_BtnSelectBestRoute.setEnabled(false);
            ((ITradeRouteTableModel)this.mo_TblTradeRoutes.getModel()).clear();
            this.mo_PgbCalculation.setVisible(true);
            this.mo_PgbCalculation.setValue(0);
            this.mo_CalculationThread = new CalculationThread();
            this.mo_CalculationThread.setPriority(2);
            this.mo_CalculationThread.start();
        }
    }

    private void mo_RBtnUniverseTargetActionPerformed(ActionEvent evt) {
        this.mo_CbbTarget.removeAllItems();
        this.mo_CbbTarget.addItem("Universe");
        this.mo_CbbTarget.setEnabled(false);
    }

    private void mo_RBtnTerritoryTargetActionPerformed(ActionEvent evt) {
        this.mo_CbbTarget.removeAllItems();
        Vector lv_Territories = this.mo_DataParser.getTerritories();
        Collections.sort(lv_Territories);
        int i = 0;
        while (i < lv_Territories.size()) {
            this.mo_CbbTarget.addItem(lv_Territories.get(i));
            ++i;
        }
        this.mo_CbbTarget.setEnabled(true);
    }

    private void mo_RBtnSystemTargetActionPerformed(ActionEvent evt) {
        this.mo_CbbTarget.removeAllItems();
        Vector lv_Systems = this.mo_DataParser.getSystems();
        Collections.sort(lv_Systems);
        int i = 0;
        while (i < lv_Systems.size()) {
            this.mo_CbbTarget.addItem(lv_Systems.get(i));
            ++i;
        }
        this.mo_CbbTarget.setEnabled(true);
    }

    private void mo_RBtnBaseTargetActionPerformed(ActionEvent evt) {
        this.mo_CbbTarget.removeAllItems();
        Vector lv_Bases = this.mo_DataParser.getBases();
        Collections.sort(lv_Bases);
        int i = 0;
        while (i < lv_Bases.size()) {
            this.mo_CbbTarget.addItem(lv_Bases.get(i));
            ++i;
        }
        this.mo_CbbTarget.setEnabled(true);
    }

    private void mo_RBtnUniverseStartActionPerformed(ActionEvent evt) {
        this.mo_CbbStart.removeAllItems();
        this.mo_CbbStart.addItem("Universe");
        this.mo_CbbStart.setEnabled(false);
    }

    private void mo_RBtnTerritoryStartActionPerformed(ActionEvent evt) {
        this.mo_CbbStart.removeAllItems();
        Vector lv_Territories = this.mo_DataParser.getTerritories();
        Collections.sort(lv_Territories);
        int i = 0;
        while (i < lv_Territories.size()) {
            this.mo_CbbStart.addItem(lv_Territories.get(i));
            ++i;
        }
        this.mo_CbbStart.setEnabled(true);
    }

    private void mo_RBtnSystemStartActionPerformed(ActionEvent evt) {
        this.mo_CbbStart.removeAllItems();
        Vector lv_Systems = this.mo_DataParser.getSystems();
        Collections.sort(lv_Systems);
        int i = 0;
        while (i < lv_Systems.size()) {
            this.mo_CbbStart.addItem(lv_Systems.get(i));
            ++i;
        }
        this.mo_CbbStart.setEnabled(true);
    }

    private void mo_RBtnBaseStartActionPerformed(ActionEvent evt) {
        this.mo_CbbStart.removeAllItems();
        Vector lv_Bases = this.mo_DataParser.getBases();
        Collections.sort(lv_Bases);
        int i = 0;
        while (i < lv_Bases.size()) {
            this.mo_CbbStart.addItem(lv_Bases.get(i));
            ++i;
        }
        this.mo_CbbStart.setEnabled(true);
    }

    private void exitForm(WindowEvent evt) {
        if (this.mo_CbmAutoSave.isSelected()) {
            this.saveSettings();
        }
        System.exit(0);
    }

    public static void main(String[] args) {
        try {
            new JavaCargoComputer().show();
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(-1);
        }
    }

    public void setStartMode(int ai_Mode) {
        switch (ai_Mode) {
            case 0: {
                this.mo_RBtnBaseStart.doClick();
                break;
            }
            case 1: {
                this.mo_RBtnSystemStart.doClick();
                break;
            }
            case 2: {
                this.mo_RBtnTerritoryStart.doClick();
                break;
            }
            case 3: {
                this.mo_RBtnUniverseStart.doClick();
            }
        }
    }

    public void setStart(String as_Name) {
        this.mo_CbbStart.setSelectedItem(this.mo_DataParser.getTradePoint(as_Name));
    }

    public void setDestinationMode(int ai_Mode) {
        switch (ai_Mode) {
            case 0: {
                this.mo_RBtnBaseTarget.doClick();
                break;
            }
            case 1: {
                this.mo_RBtnSystemTarget.doClick();
                break;
            }
            case 2: {
                this.mo_RBtnTerritoryTarget.doClick();
                break;
            }
            case 3: {
                this.mo_RBtnUniverseTarget.doClick();
            }
        }
    }

    public void setDestination(String as_Name) {
        this.mo_CbbTarget.setSelectedItem(this.mo_DataParser.getTradePoint(as_Name));
    }

    public JPopupMenu getContextMenu() {
        return this.mo_PMnuTradeRoute;
    }

    public ITradePoint getTradePoint(String as_Name) {
        return this.mo_DataParser.getTradePoint(as_Name);
    }

    public Component getMenuInvoker() {
        return this.mo_TblTradeRoutes;
    }

    public void showMultiStopTradeRouteDetails(int ai_Index) {
        MultiStopTradeRoute lo_MultiStopTradeRoute = (MultiStopTradeRoute)this.mo_MultiStopTableModel.getTradeRoute(ai_Index);
        this.mo_MultiStopTradeRouteDialog.setMultiStopTradeRoute(lo_MultiStopTradeRoute);
        this.mo_MultiStopTradeRouteDialog.show();
    }

    public int getAvailableCargo() {
        return ((PositiveSpinnerModel)this.mo_SprCargo.getModel()).getValueAsInt();
    }

    public int getAvailableMoney() {
        return ((PositiveSpinnerModel)this.mo_SprMoney.getModel()).getValueAsInt();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class CalculationThread
    extends Thread {
        CalculationThread() {
        }

        public void run() {
            Object lo_TradeRoute = null;
            int li_FilteredTradeRoutes = 0;
            Vector lv_TradeRoutes = new Vector();
            JavaCargoComputer.this.mo_DataParser.clearCache();
            int li_AvailableMoney = ((PositiveSpinnerModel)JavaCargoComputer.this.mo_SprMoney.getModel()).getValueAsInt();
            int li_AvailableCargo = ((PositiveSpinnerModel)JavaCargoComputer.this.mo_SprCargo.getModel()).getValueAsInt();
            switch (JavaCargoComputer.this.mi_TradeRouteMode) {
                case 0: {
                    li_FilteredTradeRoutes = JavaCargoComputer.this.mo_DataParser.calculateTradeRoutes2(JavaCargoComputer.this.mo_CbbStart.getSelectedItem().toString(), JavaCargoComputer.this.mo_CbbTarget.getSelectedItem().toString(), lv_TradeRoutes, JavaCargoComputer.this.mo_PgbCalculation);
                    break;
                }
                case 1: {
                    if (li_AvailableCargo == 0) {
                        JavaCargoComputer.this.mo_LblStatus.setText("no cargo available...");
                        if (JavaCargoComputer.this.mi_TradeRouteMode == 0) {
                            JavaCargoComputer.this.mo_BtnSelectBestRoute.setEnabled(true);
                        }
                        JavaCargoComputer.this.mo_BtnCalculate.setEnabled(true);
                        JavaCargoComputer.this.mo_PgbCalculation.setVisible(false);
                        JavaCargoComputer.this.mo_CalculationThread = null;
                        return;
                    }
                    if (li_AvailableMoney == 0) {
                        JavaCargoComputer.this.mo_LblStatus.setText("no money available...");
                        if (JavaCargoComputer.this.mi_TradeRouteMode == 0) {
                            JavaCargoComputer.this.mo_BtnSelectBestRoute.setEnabled(true);
                        }
                        JavaCargoComputer.this.mo_BtnCalculate.setEnabled(true);
                        JavaCargoComputer.this.mo_PgbCalculation.setVisible(false);
                        JavaCargoComputer.this.mo_CalculationThread = null;
                        return;
                    }
                    li_FilteredTradeRoutes = 0;
                    lv_TradeRoutes = JavaCargoComputer.this.mo_DataParser.createMultiStopTradeRoutes(JavaCargoComputer.this.mo_CbbStart.getSelectedItem().toString(), JavaCargoComputer.this.mo_CbbTarget.getSelectedItem().toString(), li_AvailableMoney, li_AvailableCargo, JavaCargoComputer.this.mo_PgbCalculation);
                    break;
                }
            }
            ((ITradeRouteTableModel)JavaCargoComputer.this.mo_TblTradeRoutes.getModel()).setTradeRoutes(lv_TradeRoutes);
            if (JavaCargoComputer.this.mi_TradeRouteMode == 0) {
                JavaCargoComputer.this.mo_BtnSelectBestRoute.setEnabled(true);
            }
            JavaCargoComputer.this.mo_BtnCalculate.setEnabled(true);
            JavaCargoComputer.this.mo_PgbCalculation.setVisible(false);
            JavaCargoComputer.this.mo_LblStatus.setText("created " + lv_TradeRoutes.size() + " trade routes (" + li_FilteredTradeRoutes + " excluded due to filter settings)");
            JavaCargoComputer.this.mo_CalculationThread = null;
        }
    }
}

