/*
 * Decompiled with CFR 0.152.
 */
package freelancer.universe;

import freelancer.universe.Base;
import freelancer.universe.Commodity;
import freelancer.universe.ITradePoint;
import java.util.Vector;

public class StarSystem
implements Comparable,
ITradePoint {
    private Vector mv_Bases;
    private Vector mv_Routes = new Vector();
    private String ms_Name;
    private String ms_Parent;

    public StarSystem(String as_Name) {
        this.mv_Bases = new Vector();
        this.ms_Name = as_Name;
    }

    public void addRouteTo(String as_System) {
        if (!this.mv_Routes.contains(as_System)) {
            this.mv_Routes.add(as_System);
        }
    }

    public void addBase(Base ao_Base) {
        this.mv_Bases.add(ao_Base);
    }

    public String getName() {
        return this.ms_Name;
    }

    public boolean equals(Object ao_System) {
        if (ao_System instanceof StarSystem) {
            return this.ms_Name.equalsIgnoreCase(((StarSystem)ao_System).getName());
        }
        return false;
    }

    public Vector getConnections() {
        return this.mv_Routes;
    }

    public Vector getSinglePlayerConnections() {
        Vector<String> lv_Connections = new Vector<String>();
        int i = 0;
        while (i < this.mv_Routes.size()) {
            String ls_Connection = (String)this.mv_Routes.get(i);
            if (ls_Connection.startsWith("(single)")) {
                lv_Connections.add(ls_Connection.substring(8).trim());
            } else if (!ls_Connection.startsWith("(multi)")) {
                lv_Connections.add(ls_Connection);
            }
            ++i;
        }
        return lv_Connections;
    }

    public Vector getMultiPlayerConnections() {
        Vector<String> lv_Connections = new Vector<String>();
        int i = 0;
        while (i < this.mv_Routes.size()) {
            String ls_Connection = (String)this.mv_Routes.get(i);
            if (!ls_Connection.startsWith("(single)")) {
                if (ls_Connection.startsWith("(multi)")) {
                    lv_Connections.add(ls_Connection.substring(7).trim());
                } else {
                    lv_Connections.add(ls_Connection);
                }
            }
            ++i;
        }
        return lv_Connections;
    }

    public Vector getBases() {
        return this.mv_Bases;
    }

    public Base getBase(String as_Name) {
        int i = 0;
        while (i < this.mv_Bases.size()) {
            Base lo_Base = (Base)this.mv_Bases.get(i);
            if (lo_Base.getName().equalsIgnoreCase(as_Name)) {
                return lo_Base;
            }
            ++i;
        }
        return null;
    }

    public String toString() {
        return this.ms_Name;
    }

    public int compareTo(Object ao_Object) {
        return this.getName().compareTo(((StarSystem)ao_Object).getName());
    }

    public Vector createLocationList(String as_Name) {
        Vector lv_Locations = new Vector();
        int i = 0;
        while (i < this.mv_Bases.size()) {
            ITradePoint lo_TradePoint = (ITradePoint)this.mv_Bases.get(i);
            lv_Locations.addAll(lo_TradePoint.createLocationList(as_Name));
            ++i;
        }
        return lv_Locations;
    }

    public Vector createLocationList(String as_Name, int ai_MinPrice) {
        Vector lv_Locations = new Vector();
        int i = 0;
        while (i < this.mv_Bases.size()) {
            ITradePoint lo_TradePoint = (ITradePoint)this.mv_Bases.get(i);
            lv_Locations.addAll(lo_TradePoint.createLocationList(as_Name, ai_MinPrice));
            ++i;
        }
        return lv_Locations;
    }

    public Vector getOfferedCommodities() {
        Vector<Commodity> lv_Commodities = new Vector<Commodity>();
        int i = 0;
        while (i < this.mv_Bases.size()) {
            ITradePoint lo_TradePoint = (ITradePoint)this.mv_Bases.get(i);
            Vector lv_TradePointCommodities = lo_TradePoint.getOfferedCommodities();
            int j = 0;
            while (j < lv_TradePointCommodities.size()) {
                Commodity lo_TradePointCommodity = (Commodity)lv_TradePointCommodities.get(j);
                if (lv_Commodities.contains(lo_TradePointCommodity)) {
                    int li_Index = lv_Commodities.indexOf(lo_TradePointCommodity);
                    Commodity lo_Commodity = (Commodity)lv_Commodities.remove(li_Index);
                    if (lo_Commodity.compareTo(lo_TradePointCommodity) < 0) {
                        lv_Commodities.add(li_Index, lo_Commodity);
                    } else {
                        lv_Commodities.add(li_Index, lo_TradePointCommodity);
                    }
                } else {
                    lv_Commodities.add(lo_TradePointCommodity);
                }
                ++j;
            }
            ++i;
        }
        return lv_Commodities;
    }

    public String getParent() {
        return this.ms_Parent;
    }

    public void setParent(String as_Parent) {
        this.ms_Parent = as_Parent;
    }
}

