/*
 * Decompiled with CFR 0.152.
 */
package freelancer.filter;

import java.util.Collections;
import java.util.StringTokenizer;
import java.util.Vector;

public class TradeRouteFilter {
    private Vector mv_Commodities = new Vector();
    private Vector mv_Factions = new Vector();
    private int mi_MaxTradeRouteLength = Integer.MAX_VALUE;
    private boolean mb_HideFactions = false;
    private boolean mb_HideCommodities = false;
    private boolean mb_HideLength = false;
    private int mi_Mode;

    public void addFaction(String as_Name) {
        if (!this.mv_Factions.contains(as_Name)) {
            this.mv_Factions.add(as_Name);
        }
    }

    public void addCommodity(String as_Name) {
        if (!this.mv_Commodities.contains(as_Name)) {
            this.mv_Commodities.add(as_Name);
        }
    }

    public void clearFactions() {
        this.mv_Factions.clear();
    }

    public void clearCommodities() {
        this.mv_Factions.clear();
    }

    public boolean containsFaction(String as_Name) {
        return this.mv_Factions.contains(as_Name);
    }

    public boolean containsCommodity(String as_Name) {
        return this.mv_Commodities.contains(as_Name);
    }

    public boolean hideFactions() {
        return this.mb_HideFactions;
    }

    public boolean hideCommodities() {
        return this.mb_HideCommodities;
    }

    public boolean hideLength() {
        return this.mb_HideLength;
    }

    public void setHideFactions(boolean ab_HideFactions) {
        this.mb_HideFactions = ab_HideFactions;
    }

    public void setHideCommodities(boolean ab_HideCommodities) {
        this.mb_HideCommodities = ab_HideCommodities;
    }

    public void setHideLength(boolean ab_HideLength) {
        this.mb_HideLength = ab_HideLength;
    }

    public boolean acceptFaction(String as_Name) {
        int i = 0;
        while (i < this.mv_Factions.size()) {
            if (as_Name.indexOf((String)this.mv_Factions.get(i)) != -1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean acceptCommodity(String as_Name) {
        return !this.containsCommodity(as_Name);
    }

    public boolean acceptLength(int ai_Length) {
        return ai_Length <= this.mi_MaxTradeRouteLength;
    }

    public void setFactions(Vector av_Factions) {
        this.mv_Factions = av_Factions;
    }

    public void setCommodities(Vector av_Commodities) {
        this.mv_Commodities = av_Commodities;
    }

    public Vector getFactions() {
        return this.mv_Factions;
    }

    public Vector getCommodities() {
        return this.mv_Commodities;
    }

    public String getFactionsAsString() {
        String ls_Result;
        if (this.mv_Factions.size() > 0) {
            ls_Result = (String)this.mv_Factions.get(0);
            int i = 1;
            while (i < this.mv_Factions.size()) {
                ls_Result = ls_Result + ", " + this.mv_Factions.get(i);
                ++i;
            }
        } else {
            ls_Result = "";
        }
        return ls_Result;
    }

    public String getCommoditiesAsString() {
        String ls_Result;
        if (this.mv_Commodities.size() > 0) {
            ls_Result = (String)this.mv_Commodities.get(0);
            int i = 1;
            while (i < this.mv_Commodities.size()) {
                ls_Result = ls_Result + ", " + this.mv_Commodities.get(i);
                ++i;
            }
        } else {
            ls_Result = "";
        }
        return ls_Result;
    }

    public void setFactionsAsString(String as_Filter) {
        this.mv_Factions.clear();
        StringTokenizer lo_Tokenizer = new StringTokenizer(as_Filter, ",");
        while (lo_Tokenizer.hasMoreTokens()) {
            this.mv_Factions.add(lo_Tokenizer.nextToken().trim());
        }
        Collections.sort(this.mv_Factions);
    }

    public void setCommoditiesAsString(String as_Filter) {
        this.mv_Commodities.clear();
        StringTokenizer lo_Tokenizer = new StringTokenizer(as_Filter, ",");
        while (lo_Tokenizer.hasMoreTokens()) {
            this.mv_Commodities.add(lo_Tokenizer.nextToken().trim());
        }
        Collections.sort(this.mv_Commodities);
    }

    public void setMaxTradeRouteLength(int ai_Length) {
        this.mi_MaxTradeRouteLength = ai_Length;
    }

    public int getMaxTradeRouteLength() {
        return this.mi_MaxTradeRouteLength;
    }

    public void setMode(int ai_Mode) {
        this.mi_Mode = ai_Mode;
    }

    public int getMode() {
        return this.mi_Mode;
    }
}

