/*
 * Decompiled with CFR 0.152.
 */
package freelancer.traderoutes;

import freelancer.IUserInterface;
import freelancer.traderoutes.ITradeRouteTableModel;
import freelancer.traderoutes.TradeRoute;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.table.DefaultTableModel;

public class TradeRouteTableModel
extends DefaultTableModel
implements ITradeRouteTableModel {
    private static final String[] cs_ColumnNames = new String[]{"Start", "Destination", "Commodity", "Buy", "Sell", "Profit", "Systems", "Profit/System"};
    private IUserInterface mo_UserInterface;
    private NumberFormat mo_NumberFormat;
    private TableSorter mo_TableSorter;
    private Vector mv_TradeRoutes = new Vector();
    private NumberFormat mo_DollarFormat;
    private int mi_SortedColumn = 5;
    private boolean mb_Ascending = false;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Object;

    public TradeRouteTableModel() {
        this.mo_TableSorter = new TableSorter();
        this.mo_NumberFormat = NumberFormat.getInstance(Locale.US);
        this.mo_NumberFormat.setMaximumFractionDigits(2);
        this.mo_NumberFormat.setMinimumFractionDigits(2);
        this.mo_DollarFormat = NumberFormat.getCurrencyInstance(Locale.US);
        this.mo_DollarFormat.setMaximumFractionDigits(0);
        this.mo_UserInterface = null;
    }

    public void addRow(TradeRoute ao_TradeRoute) {
        this.mv_TradeRoutes.add(ao_TradeRoute);
        this.fireTableRowsInserted(this.mv_TradeRoutes.size(), this.mv_TradeRoutes.size());
    }

    public void setTradeRoutes(Vector av_TradeRoutes) {
        this.mv_TradeRoutes = av_TradeRoutes;
        this.sortTable();
        this.fireTableDataChanged();
    }

    public String getColumnName(int ai_ColumnIndex) {
        return cs_ColumnNames[ai_ColumnIndex];
    }

    public Vector getDataVector() {
        return this.mv_TradeRoutes;
    }

    public Object getValueAt(int ai_Row, int ai_Column) {
        TradeRoute lo_TradeRoute = (TradeRoute)this.mv_TradeRoutes.get(ai_Row);
        switch (ai_Column) {
            case 0: {
                return lo_TradeRoute.getStart() + " (" + lo_TradeRoute.getStartFaction() + ")";
            }
            case 1: {
                return lo_TradeRoute.getDestination() + " (" + lo_TradeRoute.getDestinationFaction() + ")";
            }
            case 2: {
                return lo_TradeRoute.getGood();
            }
            case 3: {
                return new Integer(lo_TradeRoute.getPriceBuy());
            }
            case 4: {
                return new Integer(lo_TradeRoute.getPriceSell());
            }
            case 5: {
                return new Integer(lo_TradeRoute.getProfit());
            }
            case 6: {
                return new Short((short)lo_TradeRoute.getNumberOfSystems());
            }
            case 7: {
                return new Double((double)lo_TradeRoute.getProfit() / (double)lo_TradeRoute.getNumberOfSystems());
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public int getRowCount() {
        if (this.mv_TradeRoutes != null) {
            return this.mv_TradeRoutes.size();
        }
        return 0;
    }

    public int getColumnCount() {
        return cs_ColumnNames.length;
    }

    public boolean isCellEditable(int ai_Row, int ai_Column) {
        return false;
    }

    public void clear() {
        this.mv_TradeRoutes.clear();
        this.fireTableDataChanged();
    }

    public Class getColumnClass(int ai_ColumnIndex) {
        switch (ai_ColumnIndex) {
            case 0: {
                return class$java$lang$String == null ? (class$java$lang$String = TradeRouteTableModel.class$("java.lang.String")) : class$java$lang$String;
            }
            case 1: {
                return class$java$lang$String == null ? (class$java$lang$String = TradeRouteTableModel.class$("java.lang.String")) : class$java$lang$String;
            }
            case 2: {
                return class$java$lang$String == null ? (class$java$lang$String = TradeRouteTableModel.class$("java.lang.String")) : class$java$lang$String;
            }
            case 3: {
                return class$java$lang$Integer == null ? (class$java$lang$Integer = TradeRouteTableModel.class$("java.lang.Integer")) : class$java$lang$Integer;
            }
            case 4: {
                return class$java$lang$Integer == null ? (class$java$lang$Integer = TradeRouteTableModel.class$("java.lang.Integer")) : class$java$lang$Integer;
            }
            case 5: {
                return class$java$lang$Integer == null ? (class$java$lang$Integer = TradeRouteTableModel.class$("java.lang.Integer")) : class$java$lang$Integer;
            }
            case 6: {
                return class$java$lang$Short == null ? (class$java$lang$Short = TradeRouteTableModel.class$("java.lang.Short")) : class$java$lang$Short;
            }
            case 7: {
                return class$java$lang$Double == null ? (class$java$lang$Double = TradeRouteTableModel.class$("java.lang.Double")) : class$java$lang$Double;
            }
        }
        return class$java$lang$Object == null ? (class$java$lang$Object = TradeRouteTableModel.class$("java.lang.Object")) : class$java$lang$Object;
    }

    public void sortTable(int ai_ColumnIndex) {
        this.mo_TableSorter.sortTable(ai_ColumnIndex);
        this.fireTableDataChanged();
    }

    public void sortTable() {
        if (this.mi_SortedColumn != -1) {
            this.mb_Ascending = !this.mb_Ascending;
            this.mo_TableSorter.sortTable(this.mi_SortedColumn);
            this.fireTableDataChanged();
        }
    }

    public void showContextMenu(int ai_SelectedRow, int ai_SelectedColumn, int ai_X, int ai_Y) {
        if (this.mo_UserInterface == null) {
            return;
        }
        JPopupMenu lo_PMnuTradeRoute = this.mo_UserInterface.getContextMenu();
        if (ai_SelectedColumn == 0) {
            TradeRoute lo_TradeRoute = (TradeRoute)this.mv_TradeRoutes.get(ai_SelectedRow);
            lo_PMnuTradeRoute.removeAll();
            String ls_Name = lo_TradeRoute.getStart();
            JMenuItem lo_MenuItem = lo_PMnuTradeRoute.add("Use Base '" + ls_Name + "' as Start");
            lo_MenuItem.setActionCommand(ls_Name);
            lo_MenuItem.setFont(new Font("Dialog", 0, 12));
            lo_MenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ao_Event) {
                    TradeRouteTableModel.this.mo_UserInterface.setStartMode(0);
                    TradeRouteTableModel.this.mo_UserInterface.setStart(ao_Event.getActionCommand());
                }
            });
            ls_Name = this.mo_UserInterface.getTradePoint(lo_TradeRoute.getStart()).getParent();
            lo_MenuItem = lo_PMnuTradeRoute.add("Use System '" + ls_Name + "' as Start");
            lo_MenuItem.setActionCommand(ls_Name);
            lo_MenuItem.setFont(new Font("Dialog", 0, 12));
            lo_MenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ao_Event) {
                    TradeRouteTableModel.this.mo_UserInterface.setStartMode(1);
                    TradeRouteTableModel.this.mo_UserInterface.setStart(ao_Event.getActionCommand());
                }
            });
            ls_Name = this.mo_UserInterface.getTradePoint(this.mo_UserInterface.getTradePoint(lo_TradeRoute.getStart()).getParent()).getParent();
            lo_MenuItem = lo_PMnuTradeRoute.add("Use Territory '" + ls_Name + "' as Start");
            lo_MenuItem.setActionCommand(ls_Name);
            lo_MenuItem.setFont(new Font("Dialog", 0, 12));
            lo_MenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ao_Event) {
                    TradeRouteTableModel.this.mo_UserInterface.setStartMode(2);
                    TradeRouteTableModel.this.mo_UserInterface.setStart(ao_Event.getActionCommand());
                }
            });
            lo_PMnuTradeRoute.add(new JSeparator());
            ls_Name = lo_TradeRoute.getStart();
            lo_MenuItem = lo_PMnuTradeRoute.add("Use Base '" + ls_Name + "' as Destination");
            lo_MenuItem.setActionCommand(ls_Name);
            lo_MenuItem.setFont(new Font("Dialog", 0, 12));
            lo_MenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ao_Event) {
                    TradeRouteTableModel.this.mo_UserInterface.setDestinationMode(0);
                    TradeRouteTableModel.this.mo_UserInterface.setDestination(ao_Event.getActionCommand());
                }
            });
            ls_Name = this.mo_UserInterface.getTradePoint(lo_TradeRoute.getStart()).getParent();
            lo_MenuItem = lo_PMnuTradeRoute.add("Use System '" + ls_Name + "' as Destination");
            lo_MenuItem.setActionCommand(ls_Name);
            lo_MenuItem.setFont(new Font("Dialog", 0, 12));
            lo_MenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ao_Event) {
                    TradeRouteTableModel.this.mo_UserInterface.setDestinationMode(1);
                    TradeRouteTableModel.this.mo_UserInterface.setDestination(ao_Event.getActionCommand());
                }
            });
            ls_Name = this.mo_UserInterface.getTradePoint(this.mo_UserInterface.getTradePoint(lo_TradeRoute.getStart()).getParent()).getParent();
            lo_MenuItem = lo_PMnuTradeRoute.add("Use Territory '" + ls_Name + "' as Destination");
            lo_MenuItem.setActionCommand(ls_Name);
            lo_MenuItem.setFont(new Font("Dialog", 0, 12));
            lo_MenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ao_Event) {
                    TradeRouteTableModel.this.mo_UserInterface.setDestinationMode(2);
                    TradeRouteTableModel.this.mo_UserInterface.setDestination(ao_Event.getActionCommand());
                }
            });
            lo_PMnuTradeRoute.show(this.mo_UserInterface.getMenuInvoker(), ai_X, ai_Y);
        } else if (ai_SelectedColumn == 1) {
            TradeRoute lo_TradeRoute = (TradeRoute)this.mv_TradeRoutes.get(ai_SelectedRow);
            lo_PMnuTradeRoute.removeAll();
            String ls_Name = lo_TradeRoute.getDestination();
            JMenuItem lo_MenuItem = lo_PMnuTradeRoute.add("Use Base '" + ls_Name + "' as Start");
            lo_MenuItem.setActionCommand(ls_Name);
            lo_MenuItem.setFont(new Font("Dialog", 0, 12));
            lo_MenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ao_Event) {
                    TradeRouteTableModel.this.mo_UserInterface.setStartMode(0);
                    TradeRouteTableModel.this.mo_UserInterface.setStart(ao_Event.getActionCommand());
                }
            });
            ls_Name = this.mo_UserInterface.getTradePoint(lo_TradeRoute.getDestination()).getParent();
            lo_MenuItem = lo_PMnuTradeRoute.add("Use System '" + ls_Name + "' as Start");
            lo_MenuItem.setActionCommand(ls_Name);
            lo_MenuItem.setFont(new Font("Dialog", 0, 12));
            lo_MenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ao_Event) {
                    TradeRouteTableModel.this.mo_UserInterface.setStartMode(1);
                    TradeRouteTableModel.this.mo_UserInterface.setStart(ao_Event.getActionCommand());
                }
            });
            ls_Name = this.mo_UserInterface.getTradePoint(this.mo_UserInterface.getTradePoint(lo_TradeRoute.getDestination()).getParent()).getParent();
            lo_MenuItem = lo_PMnuTradeRoute.add("Use Territory '" + ls_Name + "' as Start");
            lo_MenuItem.setActionCommand(ls_Name);
            lo_MenuItem.setFont(new Font("Dialog", 0, 12));
            lo_MenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ao_Event) {
                    TradeRouteTableModel.this.mo_UserInterface.setStartMode(2);
                    TradeRouteTableModel.this.mo_UserInterface.setStart(ao_Event.getActionCommand());
                }
            });
            lo_PMnuTradeRoute.add(new JSeparator());
            ls_Name = lo_TradeRoute.getDestination();
            lo_MenuItem = lo_PMnuTradeRoute.add("Use Base '" + ls_Name + "' as Destination");
            lo_MenuItem.setActionCommand(ls_Name);
            lo_MenuItem.setFont(new Font("Dialog", 0, 12));
            lo_MenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ao_Event) {
                    TradeRouteTableModel.this.mo_UserInterface.setDestinationMode(0);
                    TradeRouteTableModel.this.mo_UserInterface.setDestination(ao_Event.getActionCommand());
                }
            });
            ls_Name = this.mo_UserInterface.getTradePoint(lo_TradeRoute.getDestination()).getParent();
            lo_MenuItem = lo_PMnuTradeRoute.add("Use System '" + ls_Name + "' as Destination");
            lo_MenuItem.setActionCommand(ls_Name);
            lo_MenuItem.setFont(new Font("Dialog", 0, 12));
            lo_MenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ao_Event) {
                    TradeRouteTableModel.this.mo_UserInterface.setDestinationMode(1);
                    TradeRouteTableModel.this.mo_UserInterface.setDestination(ao_Event.getActionCommand());
                }
            });
            ls_Name = this.mo_UserInterface.getTradePoint(this.mo_UserInterface.getTradePoint(lo_TradeRoute.getDestination()).getParent()).getParent();
            lo_MenuItem = lo_PMnuTradeRoute.add("Use Territory '" + ls_Name + "' as Destination");
            lo_MenuItem.setActionCommand(ls_Name);
            lo_MenuItem.setFont(new Font("Dialog", 0, 12));
            lo_MenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ao_Event) {
                    TradeRouteTableModel.this.mo_UserInterface.setDestinationMode(2);
                    TradeRouteTableModel.this.mo_UserInterface.setDestination(ao_Event.getActionCommand());
                }
            });
            lo_PMnuTradeRoute.show(this.mo_UserInterface.getMenuInvoker(), ai_X, ai_Y);
        }
    }

    public void setUserInterface(IUserInterface ao_UserInterface) {
        this.mo_UserInterface = ao_UserInterface;
    }

    public String getTradeRouteDetails(int ai_SelectedRow) {
        String ls_CommodityName = (String)this.getValueAt(ai_SelectedRow, 2);
        int li_PriceBuy = (Integer)this.getValueAt(ai_SelectedRow, 3);
        int li_PriceSell = (Integer)this.getValueAt(ai_SelectedRow, 4);
        int li_AvailableCargo = this.mo_UserInterface.getAvailableCargo();
        int li_AvailableMoney = this.mo_UserInterface.getAvailableMoney();
        if (li_AvailableCargo == 0) {
            return "no cargo space available...";
        }
        if (li_AvailableMoney == 0) {
            return "no money available...";
        }
        if (this.mv_TradeRoutes.size() == 0) {
            return "no trade routes available...";
        }
        int li_Cargo = Math.min(li_AvailableCargo, li_AvailableMoney / li_PriceBuy);
        return ls_CommodityName + "  -  Amount: " + li_Cargo + "  -  Buy: " + this.mo_DollarFormat.format(li_PriceBuy * li_Cargo) + "  -  Sell: " + this.mo_DollarFormat.format(li_PriceSell * li_Cargo) + " - Profit: " + this.mo_DollarFormat.format((li_PriceSell - li_PriceBuy) * li_Cargo);
    }

    public TradeRoute getTradeRoute(int ai_Index) {
        return (TradeRoute)this.mv_TradeRoutes.get(ai_Index);
    }

    public Vector getTradeRoutes() {
        return this.mv_TradeRoutes;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class TradeRouteComparator
    implements Comparator {
        private int mi_Column;
        private boolean mb_Ascending;

        public TradeRouteComparator(int ai_Column) {
            this.mi_Column = ai_Column;
            this.mb_Ascending = true;
        }

        public TradeRouteComparator(int ai_Column, boolean ab_Ascending) {
            this.mi_Column = ai_Column;
            this.mb_Ascending = ab_Ascending;
        }

        public int compare(Object ao_Object1, Object ao_Object2) {
            int li_Result;
            TradeRoute lo_TradeRoute1 = (TradeRoute)ao_Object1;
            TradeRoute lo_TradeRoute2 = (TradeRoute)ao_Object2;
            switch (this.mi_Column) {
                case 0: {
                    li_Result = lo_TradeRoute1.getStart().compareTo(lo_TradeRoute2.getStart());
                    break;
                }
                case 1: {
                    li_Result = lo_TradeRoute1.getDestination().compareTo(lo_TradeRoute2.getDestination());
                    break;
                }
                case 2: {
                    li_Result = lo_TradeRoute1.getGood().compareTo(lo_TradeRoute2.getGood());
                    break;
                }
                case 3: {
                    li_Result = lo_TradeRoute1.getPriceBuy() - lo_TradeRoute2.getPriceBuy();
                    break;
                }
                case 4: {
                    li_Result = lo_TradeRoute1.getPriceSell() - lo_TradeRoute2.getPriceSell();
                    break;
                }
                case 5: {
                    li_Result = lo_TradeRoute1.getProfit() - lo_TradeRoute2.getProfit();
                    break;
                }
                case 6: {
                    li_Result = lo_TradeRoute1.getNumberOfSystems() - lo_TradeRoute2.getNumberOfSystems();
                    break;
                }
                case 7: {
                    li_Result = (int)(((double)lo_TradeRoute1.getProfit() / (double)lo_TradeRoute1.getNumberOfSystems() - (double)lo_TradeRoute2.getProfit() / (double)lo_TradeRoute2.getNumberOfSystems()) * 100.0);
                    break;
                }
                default: {
                    li_Result = 0;
                }
            }
            if (!this.mb_Ascending) {
                li_Result *= -1;
            }
            return li_Result;
        }
    }

    class TableSorter {
        TableSorter() {
        }

        public void sortTable(int ai_ColumnIndex) {
            if (ai_ColumnIndex == TradeRouteTableModel.this.mi_SortedColumn) {
                TradeRouteTableModel.this.mb_Ascending = !TradeRouteTableModel.this.mb_Ascending;
                Collections.sort(TradeRouteTableModel.this.mv_TradeRoutes, new TradeRouteComparator(ai_ColumnIndex, TradeRouteTableModel.this.mb_Ascending));
            } else {
                TradeRouteTableModel.this.mb_Ascending = true;
                Collections.sort(TradeRouteTableModel.this.mv_TradeRoutes, new TradeRouteComparator(ai_ColumnIndex));
            }
            TradeRouteTableModel.this.mi_SortedColumn = ai_ColumnIndex;
        }
    }
}

