/*
 * Decompiled with CFR 0.152.
 */
package freelancer.traderoutes;

import freelancer.IUserInterface;
import freelancer.traderoutes.ITradeRouteTableModel;
import freelancer.traderoutes.MultiStopTradeRoute;
import freelancer.traderoutes.TradeRoute;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.table.DefaultTableModel;

public class MultiStopTradeRouteTableModel
extends DefaultTableModel
implements ITradeRouteTableModel {
    private static final String[] cs_ColumnNames = new String[]{"Start", "Destination", "Profit", "Stops", "Systems", "Profit/System"};
    private IUserInterface mo_UserInterface;
    private NumberFormat mo_NumberFormat;
    private TableSorter mo_TableSorter;
    private Vector mv_MultiStopTradeRoutes = new Vector();
    private int mi_SortedColumn = 5;
    private int mi_AvailableMoney;
    private int mi_AvailableCargo;
    private boolean mb_Ascending = false;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Object;

    public MultiStopTradeRouteTableModel() {
        this.mo_TableSorter = new TableSorter();
        this.mo_NumberFormat = NumberFormat.getInstance(Locale.US);
        this.mo_NumberFormat.setMaximumFractionDigits(0);
        this.mo_NumberFormat.setMinimumFractionDigits(0);
    }

    public void addRow(MultiStopTradeRoute ao_MultiStopTradeRoute) {
        this.mv_MultiStopTradeRoutes.add(ao_MultiStopTradeRoute);
        this.fireTableRowsInserted(this.mv_MultiStopTradeRoutes.size(), this.mv_MultiStopTradeRoutes.size());
    }

    public void setAvailableMoney(int ai_AvailableMoney) {
        this.mi_AvailableMoney = ai_AvailableMoney;
    }

    public void setAvailableCargo(int ai_AvailableCargo) {
        this.mi_AvailableCargo = ai_AvailableCargo;
    }

    public void setTradeRoutes(Vector av_MultiStopTradeRoutes) {
        this.mv_MultiStopTradeRoutes = av_MultiStopTradeRoutes;
        this.sortTable();
        this.fireTableDataChanged();
    }

    public String getColumnName(int ai_ColumnIndex) {
        return cs_ColumnNames[ai_ColumnIndex];
    }

    public Vector getDataVector() {
        return this.mv_MultiStopTradeRoutes;
    }

    public Object getValueAt(int ai_Row, int ai_Column) {
        MultiStopTradeRoute lo_MultiStopTradeRoute = (MultiStopTradeRoute)this.mv_MultiStopTradeRoutes.get(ai_Row);
        switch (ai_Column) {
            case 0: {
                return lo_MultiStopTradeRoute.getStart() + " (" + lo_MultiStopTradeRoute.getStartFaction() + ")";
            }
            case 1: {
                return lo_MultiStopTradeRoute.getDestination() + " (" + lo_MultiStopTradeRoute.getDestinationFaction() + ")";
            }
            case 2: {
                return new Integer(lo_MultiStopTradeRoute.getTotalProfit(this.mi_AvailableMoney, this.mi_AvailableCargo));
            }
            case 3: {
                return new Short((short)lo_MultiStopTradeRoute.getTradeRoutes().size());
            }
            case 4: {
                return new Short((short)lo_MultiStopTradeRoute.getNumberOfSystems());
            }
            case 5: {
                return new Double((double)lo_MultiStopTradeRoute.getTotalProfit(this.mi_AvailableMoney, this.mi_AvailableCargo) / (double)lo_MultiStopTradeRoute.getNumberOfSystems());
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public int getRowCount() {
        if (this.mv_MultiStopTradeRoutes != null) {
            return this.mv_MultiStopTradeRoutes.size();
        }
        return 0;
    }

    public int getColumnCount() {
        return cs_ColumnNames.length;
    }

    public boolean isCellEditable(int ai_Row, int ai_Column) {
        return false;
    }

    public void clear() {
        this.mv_MultiStopTradeRoutes.clear();
        this.fireTableDataChanged();
    }

    public Class getColumnClass(int ai_ColumnIndex) {
        switch (ai_ColumnIndex) {
            case 0: {
                return class$java$lang$String == null ? (class$java$lang$String = MultiStopTradeRouteTableModel.class$("java.lang.String")) : class$java$lang$String;
            }
            case 1: {
                return class$java$lang$String == null ? (class$java$lang$String = MultiStopTradeRouteTableModel.class$("java.lang.String")) : class$java$lang$String;
            }
            case 2: {
                return class$java$lang$Integer == null ? (class$java$lang$Integer = MultiStopTradeRouteTableModel.class$("java.lang.Integer")) : class$java$lang$Integer;
            }
            case 3: {
                return class$java$lang$Short == null ? (class$java$lang$Short = MultiStopTradeRouteTableModel.class$("java.lang.Short")) : class$java$lang$Short;
            }
            case 4: {
                return class$java$lang$Short == null ? (class$java$lang$Short = MultiStopTradeRouteTableModel.class$("java.lang.Short")) : class$java$lang$Short;
            }
            case 5: {
                return class$java$lang$Double == null ? (class$java$lang$Double = MultiStopTradeRouteTableModel.class$("java.lang.Double")) : class$java$lang$Double;
            }
        }
        return class$java$lang$Object == null ? (class$java$lang$Object = MultiStopTradeRouteTableModel.class$("java.lang.Object")) : class$java$lang$Object;
    }

    public void sortTable(int ai_ColumnIndex) {
        this.mo_TableSorter.sortTable(ai_ColumnIndex);
        this.fireTableDataChanged();
    }

    public void sortTable() {
        if (this.mi_SortedColumn != -1) {
            this.mb_Ascending = !this.mb_Ascending;
            this.mo_TableSorter.sortTable(this.mi_SortedColumn);
            this.fireTableDataChanged();
        }
    }

    public void showContextMenu(int ai_SelectedRow, int ai_SelectedColumn, int ai_X, int ai_Y) {
        final int li_SelectedRow = ai_SelectedRow;
        if (this.mo_UserInterface == null) {
            return;
        }
        JPopupMenu lo_PMnuTradeRoute = this.mo_UserInterface.getContextMenu();
        lo_PMnuTradeRoute.removeAll();
        JMenuItem lo_MenuItem = lo_PMnuTradeRoute.add("Show Details");
        lo_MenuItem.setFont(new Font("Dialog", 0, 12));
        lo_MenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ao_Event) {
                MultiStopTradeRouteTableModel.this.mo_UserInterface.showMultiStopTradeRouteDetails(li_SelectedRow);
            }
        });
        lo_PMnuTradeRoute.show(this.mo_UserInterface.getMenuInvoker(), ai_X, ai_Y);
    }

    public void setUserInterface(IUserInterface ao_UserInterface) {
        this.mo_UserInterface = ao_UserInterface;
    }

    public String getTradeRouteDetails(int ai_SelectedRow) {
        MultiStopTradeRoute lo_MultiStopTradeRoute = (MultiStopTradeRoute)this.mv_MultiStopTradeRoutes.get(ai_SelectedRow);
        return "Systems: " + lo_MultiStopTradeRoute.getNumberOfSystems() + "  -  Stops: " + lo_MultiStopTradeRoute.getTradeRoutes().size() + "  -  Profit: $" + this.mo_NumberFormat.format(lo_MultiStopTradeRoute.getTotalProfit(this.mi_AvailableMoney, this.mi_AvailableCargo));
    }

    public TradeRoute getTradeRoute(int ai_Index) {
        return (MultiStopTradeRoute)this.mv_MultiStopTradeRoutes.get(ai_Index);
    }

    public Vector getTradeRoutes() {
        return this.mv_MultiStopTradeRoutes;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class TradeRouteComparator
    implements Comparator {
        private int mi_Column;
        private boolean mb_Ascending;

        public TradeRouteComparator(int ai_Column) {
            this.mi_Column = ai_Column;
            this.mb_Ascending = true;
        }

        public TradeRouteComparator(int ai_Column, boolean ab_Ascending) {
            this.mi_Column = ai_Column;
            this.mb_Ascending = ab_Ascending;
        }

        public int compare(Object ao_Object1, Object ao_Object2) {
            int li_Result;
            MultiStopTradeRoute lo_MultiStopTradeRoute1 = (MultiStopTradeRoute)ao_Object1;
            MultiStopTradeRoute lo_MultiStopTradeRoute2 = (MultiStopTradeRoute)ao_Object2;
            switch (this.mi_Column) {
                case 0: {
                    li_Result = lo_MultiStopTradeRoute1.getStart().compareTo(lo_MultiStopTradeRoute2.getStart());
                    break;
                }
                case 1: {
                    li_Result = lo_MultiStopTradeRoute1.getDestination().compareTo(lo_MultiStopTradeRoute2.getDestination());
                    break;
                }
                case 2: {
                    li_Result = lo_MultiStopTradeRoute1.getTotalProfit(MultiStopTradeRouteTableModel.this.mi_AvailableMoney, MultiStopTradeRouteTableModel.this.mi_AvailableCargo) - lo_MultiStopTradeRoute2.getTotalProfit(MultiStopTradeRouteTableModel.this.mi_AvailableMoney, MultiStopTradeRouteTableModel.this.mi_AvailableCargo);
                    break;
                }
                case 3: {
                    li_Result = lo_MultiStopTradeRoute1.getTradeRoutes().size() - lo_MultiStopTradeRoute2.getTradeRoutes().size();
                    break;
                }
                case 4: {
                    li_Result = lo_MultiStopTradeRoute1.getNumberOfSystems() - lo_MultiStopTradeRoute2.getNumberOfSystems();
                    break;
                }
                case 5: {
                    li_Result = (int)(((double)lo_MultiStopTradeRoute1.getTotalProfit(MultiStopTradeRouteTableModel.this.mi_AvailableMoney, MultiStopTradeRouteTableModel.this.mi_AvailableCargo) / (double)lo_MultiStopTradeRoute1.getNumberOfSystems() - (double)lo_MultiStopTradeRoute2.getTotalProfit(MultiStopTradeRouteTableModel.this.mi_AvailableMoney, MultiStopTradeRouteTableModel.this.mi_AvailableCargo) / (double)lo_MultiStopTradeRoute2.getNumberOfSystems()) * 100.0);
                    break;
                }
                default: {
                    li_Result = 0;
                }
            }
            if (!this.mb_Ascending) {
                li_Result *= -1;
            }
            return li_Result;
        }
    }

    class TableSorter {
        TableSorter() {
        }

        public void sortTable(int ai_ColumnIndex) {
            if (ai_ColumnIndex == MultiStopTradeRouteTableModel.this.mi_SortedColumn) {
                MultiStopTradeRouteTableModel.this.mb_Ascending = !MultiStopTradeRouteTableModel.this.mb_Ascending;
                Collections.sort(MultiStopTradeRouteTableModel.this.mv_MultiStopTradeRoutes, new TradeRouteComparator(ai_ColumnIndex, MultiStopTradeRouteTableModel.this.mb_Ascending));
            } else {
                MultiStopTradeRouteTableModel.this.mb_Ascending = true;
                Collections.sort(MultiStopTradeRouteTableModel.this.mv_MultiStopTradeRoutes, new TradeRouteComparator(ai_ColumnIndex));
            }
            MultiStopTradeRouteTableModel.this.mi_SortedColumn = ai_ColumnIndex;
        }
    }
}

