/*
 * Decompiled with CFR 0.152.
 */
package freelancer;

import java.text.NumberFormat;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractSpinnerModel;

public class PositiveSpinnerModel
extends AbstractSpinnerModel {
    private Object mo_Value;
    private Vector mv_ChangeListeners;
    private NumberFormat mo_NumberFormat;
    private int mi_StepValue;
    private int mi_MinValue;
    private int mi_MaxValue;

    public PositiveSpinnerModel() {
        this(1, 0, Integer.MAX_VALUE);
    }

    public PositiveSpinnerModel(int ai_StepValue) {
        this(ai_StepValue, 0, Integer.MAX_VALUE);
    }

    public PositiveSpinnerModel(int ai_StepValue, int ai_MinValue, int ai_MaxValue) {
        this.mi_StepValue = ai_StepValue;
        this.mi_MinValue = ai_MinValue;
        this.mi_MaxValue = ai_MaxValue;
        this.mo_NumberFormat = NumberFormat.getNumberInstance(Locale.US);
        this.mo_NumberFormat.setMaximumFractionDigits(0);
        this.mv_ChangeListeners = new Vector();
        this.mo_Value = "0";
    }

    public void setStepWidth(int ai_Value) {
        this.mi_StepValue = ai_Value;
    }

    public Object getPreviousValue() {
        try {
            int li_Value = this.mo_NumberFormat.parse((String)this.getValue()).intValue();
            if (li_Value > this.mi_MinValue) {
                if (li_Value - this.mi_StepValue < this.mi_MinValue) {
                    return this.mo_NumberFormat.format(li_Value - 1);
                }
                return this.mo_NumberFormat.format(li_Value - this.mi_StepValue);
            }
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public Object getNextValue() {
        try {
            int li_Value = this.mo_NumberFormat.parse((String)this.getValue()).intValue();
            if (li_Value >= this.mi_MaxValue) {
                return null;
            }
            if (li_Value + this.mi_StepValue > this.mi_MaxValue) {
                return this.mo_NumberFormat.format(li_Value + 1);
            }
            return this.mo_NumberFormat.format(li_Value + this.mi_StepValue);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void setValue(Object ao_Value) {
        try {
            String as_Value = (String)ao_Value;
            if (as_Value.startsWith("$")) {
                as_Value = as_Value.substring(1);
            }
            int li_Value = this.mo_NumberFormat.parse(as_Value).intValue();
            li_Value = Math.max(Math.min(li_Value, this.mi_MaxValue), this.mi_MinValue);
            this.mo_Value = this.mo_NumberFormat.format(li_Value);
            this.fireStateChanged();
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Only whole numbers greater or equal to zero are supported!");
        }
    }

    public Object getValue() {
        return this.mo_Value;
    }

    public int getValueAsInt() {
        try {
            return this.mo_NumberFormat.parse((String)this.mo_Value).intValue();
        }
        catch (Exception ex) {
            return 0;
        }
    }
}

