/*
 * Decompiled with CFR 0.152.
 */
package freelancer;

import freelancer.filter.TradeRouteFilter;
import freelancer.traderoutes.MultiStopTradeRoute;
import freelancer.traderoutes.TradeRoute;
import freelancer.universe.Base;
import freelancer.universe.Commodity;
import freelancer.universe.ITradePoint;
import freelancer.universe.Location;
import freelancer.universe.Node;
import freelancer.universe.StarSystem;
import freelancer.universe.Territory;
import freelancer.universe.Universe;
import java.awt.Point;
import java.io.File;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Collections;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JProgressBar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class DataParser {
    public static final int SINGLE_PLAYER = 0;
    public static final int MULTI_PLAYER = 1;
    private Universe mo_Universe;
    private TradeRouteFilter mo_Filter = null;
    private Vector mv_CommodityNames;
    private Vector mv_Factions;
    private Vector mv_Ships;
    private Hashtable mh_Positions;
    private Hashtable mh_Routes;
    private Hashtable mh_TradeRouteChains;
    private Hashtable mh_TradeRoutes;
    private Hashtable mh_MultiStopTradeRoutes;
    private int mi_MapMode = 0;
    private int mi_MaxTradeRouteLength;
    private int[] ma_Counts = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private Vector mv_ProgressEventListener;

    public DataParser() throws Exception {
        this.mv_CommodityNames = new Vector();
        this.mv_Factions = new Vector();
        this.mv_Ships = new Vector();
        this.mh_Positions = new Hashtable();
        this.mh_TradeRouteChains = new Hashtable();
        this.mh_Routes = new Hashtable();
        this.mh_TradeRoutes = new Hashtable();
        this.mh_MultiStopTradeRoutes = new Hashtable();
        this.mo_Universe = this.importData();
        this.mv_ProgressEventListener = new Vector();
    }

    public ITradePoint getTradePoint(String as_Name) {
        ITradePoint lo_TradePoint;
        if (as_Name.equalsIgnoreCase("universe")) {
            lo_TradePoint = this.mo_Universe;
        } else {
            lo_TradePoint = this.mo_Universe.getTerritory(as_Name);
            if (lo_TradePoint == null && (lo_TradePoint = this.mo_Universe.getStarSystem(as_Name)) == null) {
                lo_TradePoint = this.mo_Universe.getBase(as_Name);
            }
        }
        return lo_TradePoint;
    }

    public Universe getUniverse() {
        return this.mo_Universe;
    }

    public Vector getOfferedCommotidiesForTradePoint(ITradePoint ao_TradePoint) {
        return ao_TradePoint.getOfferedCommodities();
    }

    public Vector getBases() {
        return this.mo_Universe.getBases();
    }

    public Vector getSystems() {
        return this.mo_Universe.getStarSystems();
    }

    public Vector getTerritories() {
        return this.mo_Universe.getTerritories();
    }

    public void exportData() throws Exception {
        DocumentBuilder lo_DocumentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document lo_Document = lo_DocumentBuilder.newDocument();
        Element lo_Root = lo_Document.createElement("universe");
        lo_Document.appendChild(lo_Root);
        int i = 0;
        while (i < this.mo_Universe.getTerritories().size()) {
            Territory lo_Territory = (Territory)this.mo_Universe.getTerritories().get(i);
            Element lo_TerritoryNode = lo_Document.createElement("territory");
            this.addAttribute(lo_Document, lo_TerritoryNode, "name", lo_Territory.getName());
            lo_Root.appendChild(lo_TerritoryNode);
            int j = 0;
            while (j < lo_Territory.getSystems().size()) {
                StarSystem lo_System = (StarSystem)lo_Territory.getSystems().get(j);
                Element lo_SystemNode = lo_Document.createElement("systems");
                this.addAttribute(lo_Document, lo_SystemNode, "name", lo_System.getName());
                lo_TerritoryNode.appendChild(lo_SystemNode);
                int k = 0;
                while (k < lo_System.getBases().size()) {
                    Base lo_Base = (Base)lo_System.getBases().get(k);
                    Element lo_BaseNode = lo_Document.createElement("base");
                    this.addAttribute(lo_Document, lo_BaseNode, "name", lo_Base.getName());
                    this.addAttribute(lo_Document, lo_BaseNode, "fraction", lo_Base.getFaction());
                    lo_SystemNode.appendChild(lo_BaseNode);
                    int l = 0;
                    while (l < lo_Base.getCommodities().size()) {
                        Commodity lo_Commodity = (Commodity)lo_Base.getCommodities().get(l);
                        Element lo_CommodityNode = lo_Document.createElement("commodity");
                        this.addAttribute(lo_Document, lo_CommodityNode, "name", lo_Commodity.getName());
                        this.addAttribute(lo_Document, lo_CommodityNode, "price", String.valueOf(lo_Commodity.getPrice()));
                        this.addAttribute(lo_Document, lo_CommodityNode, "sells", String.valueOf(lo_Commodity.isSold()));
                        lo_BaseNode.appendChild(lo_CommodityNode);
                        ++l;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        Transformer lo_Transformer = TransformerFactory.newInstance().newTransformer();
        lo_Transformer.setOutputProperty("indent", "yes");
        lo_Transformer.setOutputProperty("method", "xml");
        lo_Transformer.setOutputProperty("standalone", "yes");
        DOMSource lo_DOMSource = new DOMSource(lo_Document);
        StreamResult lo_StreamResult = new StreamResult(new File("d:/eigene dateien/code/freelancer/commodities.xml"));
        lo_Transformer.transform(lo_DOMSource, lo_StreamResult);
    }

    private Universe importData() throws Exception {
        Universe lo_Universe = new Universe();
        DocumentBuilder lo_DocumentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        String ls_DecodedData = this.decodeDataFile();
        Document lo_Document = lo_DocumentBuilder.parse(new InputSource(new StringReader(ls_DecodedData)));
        Element lo_Root = lo_Document.getDocumentElement();
        org.w3c.dom.Node lo_UniverseNode = lo_Root.getFirstChild();
        while (lo_UniverseNode.getNodeType() != 1 || !lo_UniverseNode.getNodeName().equalsIgnoreCase("universe")) {
            lo_UniverseNode = lo_UniverseNode.getNextSibling();
        }
        NodeList lo_TerritoryNodes = lo_UniverseNode.getChildNodes();
        int i = 0;
        while (i < lo_TerritoryNodes.getLength()) {
            org.w3c.dom.Node lo_TerritoryNode = lo_TerritoryNodes.item(i);
            if (lo_TerritoryNode.getNodeType() == 1) {
                Territory lo_Territory = new Territory(lo_TerritoryNode.getAttributes().getNamedItem("name").getNodeValue());
                lo_Universe.addTerritory(lo_Territory);
                NodeList lo_SystemNodes = lo_TerritoryNode.getChildNodes();
                int j = 0;
                while (j < lo_SystemNodes.getLength()) {
                    org.w3c.dom.Node lo_SystemNode = lo_SystemNodes.item(j);
                    if (lo_SystemNode.getNodeType() == 1) {
                        StringTokenizer lo_Tokenizer;
                        StarSystem lo_System = new StarSystem(lo_SystemNode.getAttributes().getNamedItem("name").getNodeValue());
                        lo_System.setParent(lo_Territory.getName());
                        try {
                            lo_Tokenizer = new StringTokenizer(lo_SystemNode.getAttributes().getNamedItem("position").getNodeValue(), ",");
                            this.mh_Positions.put(lo_System.getName(), new Point(new Integer(lo_Tokenizer.nextToken().trim()), new Integer(lo_Tokenizer.nextToken().trim())));
                        }
                        catch (Exception ex) {
                            System.out.println("no position data for system " + lo_System.getName());
                            this.mh_Positions.put(lo_System.getName(), new Point(0, 0));
                        }
                        try {
                            lo_Tokenizer = new StringTokenizer(lo_SystemNode.getAttributes().getNamedItem("connections").getNodeValue(), ",");
                            while (lo_Tokenizer.hasMoreTokens()) {
                                lo_System.addRouteTo(lo_Tokenizer.nextToken().trim());
                            }
                        }
                        catch (Exception ex) {
                            System.out.println("no connection data for system " + lo_System.getName());
                            this.mh_Positions.put(lo_System.getName(), new Point(0, 0));
                        }
                        lo_Territory.addStarSystem(lo_System);
                        NodeList lo_BaseNodes = lo_SystemNode.getChildNodes();
                        int k = 0;
                        while (k < lo_BaseNodes.getLength()) {
                            org.w3c.dom.Node lo_BaseNode = lo_BaseNodes.item(k);
                            if (lo_BaseNode.getNodeType() == 1) {
                                String ls_Faction = lo_BaseNode.getAttributes().getNamedItem("fraction").getNodeValue();
                                if (!this.mv_Factions.contains(ls_Faction)) {
                                    this.mv_Factions.add(ls_Faction);
                                }
                                Base lo_Base = new Base(lo_BaseNode.getAttributes().getNamedItem("name").getNodeValue(), ls_Faction);
                                lo_Base.setParentSystem(lo_System.getName());
                                lo_Base.setParentTerritory(lo_Territory.getName());
                                lo_System.addBase(lo_Base);
                                NodeList lo_CommodityNodes = lo_BaseNode.getChildNodes();
                                int l = 0;
                                while (l < lo_CommodityNodes.getLength()) {
                                    org.w3c.dom.Node lo_CommodityNode = lo_CommodityNodes.item(l);
                                    if (lo_CommodityNode.getNodeType() == 1) {
                                        Commodity lo_Commodity = new Commodity(lo_CommodityNode.getAttributes().getNamedItem("name").getNodeValue(), Integer.parseInt(lo_CommodityNode.getAttributes().getNamedItem("price").getNodeValue()), lo_CommodityNode.getAttributes().getNamedItem("sells").getNodeValue().equalsIgnoreCase("true"));
                                        lo_Base.addCommodity(lo_Commodity);
                                        if (!this.mv_CommodityNames.contains(lo_Commodity.getName())) {
                                            this.mv_CommodityNames.add(lo_Commodity.getName());
                                        }
                                    }
                                    ++l;
                                }
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        Collections.sort(this.mv_Factions);
        return lo_Universe;
    }

    /*
     * WARNING - void declaration
     */
    private String decodeDataFile() throws Exception {
        int li_Byte;
        String KEYWORD = "FrEeLaNcEr";
        int li_Count = 0;
        StringBuffer lo_StringBuffer = new StringBuffer();
        InputStream lo_InputStream = this.getClass().getResourceAsStream("universe.dat");
        while ((li_Byte = lo_InputStream.read()) != -1) {
            void var4_5;
            li_Byte = var4_5 - "FrEeLaNcEr".charAt(li_Count);
            lo_StringBuffer.append((char)li_Byte);
            ++li_Count;
            li_Count %= "FrEeLaNcEr".length();
        }
        return lo_StringBuffer.toString();
    }

    private void addAttribute(Document ao_Document, org.w3c.dom.Node ao_Node, String as_AttributeName, String as_AttributeValue) {
        Attr lo_Attribute = ao_Document.createAttribute(as_AttributeName);
        lo_Attribute.setValue(as_AttributeValue);
        ao_Node.getAttributes().setNamedItem(lo_Attribute);
    }

    public void setFilter(TradeRouteFilter ao_Filter) {
        this.mo_Filter = ao_Filter;
    }

    public Vector getFactions() {
        return this.mv_Factions;
    }

    public Vector getCommodities() {
        return this.mv_CommodityNames;
    }

    public Hashtable getPositions() {
        return this.mh_Positions;
    }

    public Vector calcRoute(String as_StartSystemName, String as_TargetSystemName) {
        return this.calcRoute(as_StartSystemName, as_TargetSystemName, this.mi_MapMode);
    }

    public Vector calcRoute(String as_StartSystemName, String as_TargetSystemName, int ai_Mode) {
        Node lo_CurrentNode;
        int li_Counter = 0;
        Vector<String> lv_Route = (Vector<String>)this.mh_Routes.get(as_StartSystemName + "-" + as_TargetSystemName);
        if (lv_Route != null) {
            return lv_Route;
        }
        Vector<Node> lv_NodesToCheck = new Vector<Node>();
        Vector<String> lv_Visited = new Vector<String>();
        lv_Route = new Vector<String>();
        lv_NodesToCheck.add(new Node(as_StartSystemName));
        do {
            StarSystem lo_StarSystem;
            if ((lo_StarSystem = this.mo_Universe.getStarSystem((lo_CurrentNode = (Node)lv_NodesToCheck.remove(0)).getName())) == null) {
                System.out.println("unable to find system " + lo_CurrentNode.getName());
            } else {
                Vector lv_Connections;
                switch (ai_Mode) {
                    case 0: {
                        lv_Connections = lo_StarSystem.getSinglePlayerConnections();
                        break;
                    }
                    case 1: {
                        lv_Connections = lo_StarSystem.getMultiPlayerConnections();
                        break;
                    }
                    default: {
                        lv_Connections = lo_StarSystem.getConnections();
                    }
                }
                int i = 0;
                while (i < lv_Connections.size()) {
                    if (!lv_Visited.contains((String)lv_Connections.get(i))) {
                        Node lo_ChildNode = new Node((String)lv_Connections.get(i));
                        lo_ChildNode.setParent(lo_CurrentNode);
                        lv_NodesToCheck.add(lo_ChildNode);
                        lv_Visited.add((String)lv_Connections.get(i));
                    }
                    ++i;
                }
            }
            ++li_Counter;
        } while (!lo_CurrentNode.getName().equalsIgnoreCase(as_TargetSystemName) && lv_NodesToCheck.size() > 0);
        while (lo_CurrentNode.getParent() != null) {
            lv_Route.add(lo_CurrentNode.getName());
            lo_CurrentNode = lo_CurrentNode.getParent();
        }
        lv_Route.add(lo_CurrentNode.getName());
        Collections.reverse(lv_Route);
        this.mh_Routes.put(as_StartSystemName + "-" + as_TargetSystemName, lv_Route);
        return lv_Route;
    }

    public Vector getShips() {
        return this.mv_Ships;
    }

    public void setMapMode(int ai_MapMode) {
        this.mi_MapMode = ai_MapMode;
    }

    public Vector createMultiStopTradeRoutes(String as_Start, String as_Destination, int ai_AvailableMoney, int ai_AvailableCargo) {
        return this.createMultiStopTradeRoutes(as_Start, as_Destination, ai_AvailableMoney, ai_AvailableCargo, null);
    }

    public Vector createMultiStopTradeRoutes(String as_Start, String as_Destination, int ai_AvailableMoney, int ai_AvailableCargo, JProgressBar ao_ProgressBar) {
        Base lo_DestinationBase;
        Base lo_StartBase;
        int li_Needed = 0;
        int li_Calculated = 0;
        Vector lv_StartBases = (Vector)this.getTradePoint(as_Start).getBases().clone();
        Vector lv_DestinationBases = (Vector)this.getTradePoint(as_Destination).getBases().clone();
        Vector<TradeRoute> lv_TradeRouteChain = new Vector<TradeRoute>();
        Vector<MultiStopTradeRoute> lv_Result = new Vector<MultiStopTradeRoute>();
        int i = 0;
        while (i < lv_StartBases.size()) {
            lo_StartBase = (Base)lv_StartBases.get(i);
            if (this.mo_Filter != null && this.mo_Filter.hideFactions() && !this.mo_Filter.acceptFaction(lo_StartBase.getFaction())) {
                lv_StartBases.remove(lo_StartBase);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < lv_DestinationBases.size()) {
            lo_DestinationBase = (Base)lv_DestinationBases.get(i2);
            if (this.mo_Filter != null && this.mo_Filter.hideFactions() && !this.mo_Filter.acceptFaction(lo_DestinationBase.getFaction())) {
                lv_DestinationBases.remove(lo_DestinationBase);
            }
            ++i2;
        }
        if (ao_ProgressBar != null) {
            ao_ProgressBar.setMaximum(lv_StartBases.size() * lv_DestinationBases.size());
        }
        int li_StartIndex = 0;
        while (li_StartIndex < lv_StartBases.size()) {
            int li_DestinationIndex = 0;
            while (li_DestinationIndex < lv_DestinationBases.size()) {
                MultiStopTradeRoute lo_MultiStopTradeRoute;
                TradeRoute lo_TradeRoute;
                int li_BestTradeRoute;
                Vector lv_TradeRoutes;
                lv_TradeRouteChain.clear();
                int li_MaxProfit = 0;
                lo_StartBase = (Base)lv_StartBases.get(li_StartIndex);
                lo_DestinationBase = (Base)lv_DestinationBases.get(li_DestinationIndex);
                Vector lv_Systems = this.calcRoute(lo_StartBase.getParent(), lo_DestinationBase.getParent());
                if (ao_ProgressBar != null) {
                    ao_ProgressBar.setValue(li_StartIndex * lv_DestinationBases.size() + li_DestinationIndex);
                }
                if (lv_Systems.size() > 2) {
                    int j;
                    int li_Cargo;
                    lv_TradeRoutes = new Vector();
                    this.calculateTradeRoutes2(lo_StartBase, lo_DestinationBase, lv_TradeRoutes, null);
                    li_BestTradeRoute = this.getBestTradeRoute(lv_TradeRoutes, ai_AvailableMoney, ai_AvailableCargo);
                    if (li_BestTradeRoute != -1) {
                        lo_TradeRoute = (TradeRoute)lv_TradeRoutes.get(li_BestTradeRoute);
                        li_Cargo = Math.min(ai_AvailableCargo, ai_AvailableMoney / lo_TradeRoute.getPriceBuy());
                        li_MaxProfit = li_Cargo * lo_TradeRoute.getProfit();
                        lv_TradeRouteChain.clear();
                        lv_TradeRouteChain.add(lo_TradeRoute);
                    }
                    int i3 = 1;
                    while (i3 < lv_Systems.size() - 1) {
                        lv_TradeRoutes = new Vector();
                        this.calculateTradeRoutes2(lo_StartBase.getName(), (String)lv_Systems.get(i3), lv_TradeRoutes, null);
                        j = 0;
                        while (j < lv_TradeRoutes.size()) {
                            Vector lv_SubTradeRouteChain;
                            lo_TradeRoute = (TradeRoute)lv_TradeRoutes.get(j);
                            li_Cargo = Math.min(ai_AvailableCargo, ai_AvailableMoney / lo_TradeRoute.getPriceBuy());
                            int li_Profit = li_Cargo * lo_TradeRoute.getProfit();
                            if (ao_ProgressBar != null) {
                                ++li_Needed;
                            }
                            if ((lv_SubTradeRouteChain = (Vector)this.mh_TradeRouteChains.get(lo_TradeRoute.getDestination() + lo_DestinationBase.getName())) == null) {
                                if (ao_ProgressBar != null) {
                                    ++li_Calculated;
                                }
                                lv_SubTradeRouteChain = this.createMultiStopTradeRoutes(lo_TradeRoute.getDestination(), lo_DestinationBase.getName(), ai_AvailableMoney + li_Profit, ai_AvailableCargo);
                                this.mh_TradeRouteChains.put(lo_TradeRoute.getDestination() + lo_DestinationBase.getName(), lv_SubTradeRouteChain);
                            }
                            if (lv_SubTradeRouteChain.size() != 0) {
                                li_Profit += ((MultiStopTradeRoute)lv_SubTradeRouteChain.get(0)).getTotalProfit(ai_AvailableMoney + li_Profit, ai_AvailableCargo);
                            }
                            if (li_Profit > li_MaxProfit) {
                                lv_TradeRouteChain.clear();
                                lv_TradeRouteChain.add(lo_TradeRoute);
                                if (lv_SubTradeRouteChain.size() != 0) {
                                    lv_TradeRouteChain.addAll(((MultiStopTradeRoute)lv_SubTradeRouteChain.get(0)).getTradeRoutes());
                                }
                                li_MaxProfit = li_Profit;
                            }
                            ++j;
                        }
                        ++i3;
                    }
                    lo_MultiStopTradeRoute = new MultiStopTradeRoute();
                    j = 0;
                    while (j < lv_TradeRouteChain.size()) {
                        lo_MultiStopTradeRoute.addTradeRoute((TradeRoute)lv_TradeRouteChain.get(j));
                        ++j;
                    }
                    lo_MultiStopTradeRoute.setNumberOfSystems(lv_Systems.size());
                    if (lo_MultiStopTradeRoute.getDestination() == null) {
                        lo_TradeRoute = new TradeRoute(lo_StartBase.getName(), lo_DestinationBase.getName(), "none", 0, 0);
                        lo_TradeRoute.setNumberOfSystems(lv_Systems.size());
                        lo_TradeRoute.setStartFaction(lo_StartBase.getFaction());
                        lo_TradeRoute.setDestinationFaction(lo_DestinationBase.getFaction());
                        lo_MultiStopTradeRoute.addTradeRoute(lo_TradeRoute);
                    } else if (!lo_MultiStopTradeRoute.getDestination().equalsIgnoreCase(lo_DestinationBase.getName())) {
                        lo_TradeRoute = new TradeRoute(lo_MultiStopTradeRoute.getDestination(), lo_DestinationBase.getName(), "none", 0, 0);
                        lo_TradeRoute.setNumberOfSystems(this.calcRoute(this.getTradePoint(lo_MultiStopTradeRoute.getDestination()).getParent(), lo_DestinationBase.getName()).size());
                        lo_TradeRoute.setStartFaction(((Base)this.getTradePoint(lo_MultiStopTradeRoute.getDestination())).getFaction());
                        lo_TradeRoute.setDestinationFaction(lo_DestinationBase.getFaction());
                    }
                    if (lo_MultiStopTradeRoute.getTotalProfit(ai_AvailableMoney, ai_AvailableCargo) > 0) {
                        lv_Result.add(lo_MultiStopTradeRoute);
                    }
                } else if (lv_Systems.size() == 2) {
                    lv_TradeRoutes = new Vector();
                    this.calculateTradeRoutes2(lo_StartBase, lo_DestinationBase, lv_TradeRoutes, null);
                    li_BestTradeRoute = this.getBestTradeRoute(lv_TradeRoutes, ai_AvailableMoney, ai_AvailableCargo);
                    if (li_BestTradeRoute != -1) {
                        lo_MultiStopTradeRoute = new MultiStopTradeRoute();
                        lo_MultiStopTradeRoute.addTradeRoute((TradeRoute)lv_TradeRoutes.get(li_BestTradeRoute));
                        lo_MultiStopTradeRoute.setNumberOfSystems(lv_Systems.size());
                        lv_Result.add(lo_MultiStopTradeRoute);
                    } else if (ao_ProgressBar == null) {
                        lo_MultiStopTradeRoute = new MultiStopTradeRoute();
                        lo_TradeRoute = new TradeRoute(lo_StartBase.getName(), lo_DestinationBase.getName(), "none", 0, 0);
                        lo_TradeRoute.setStartFaction(lo_StartBase.getFaction());
                        lo_TradeRoute.setDestinationFaction(lo_DestinationBase.getFaction());
                        lo_MultiStopTradeRoute.addTradeRoute(lo_TradeRoute);
                        lo_MultiStopTradeRoute.setNumberOfSystems(lv_Systems.size());
                        lv_Result.add(lo_MultiStopTradeRoute);
                    }
                }
                ++li_DestinationIndex;
            }
            ++li_StartIndex;
        }
        if (ao_ProgressBar != null) {
            System.out.println("calculations: " + li_Calculated + "/" + li_Needed);
        }
        return lv_Result;
    }

    public int getBestTradeRoute(Vector av_TradeRoutes, int ai_AvailableMoney, int ai_AvailableCargo) {
        int li_MaxProfit = 0;
        int li_Index = -1;
        int i = 0;
        while (i < av_TradeRoutes.size()) {
            TradeRoute lo_TradeRoute = (TradeRoute)av_TradeRoutes.get(i);
            int li_Cargo = Math.min(ai_AvailableCargo, ai_AvailableMoney / lo_TradeRoute.getPriceBuy());
            int li_Profit = li_Cargo * lo_TradeRoute.getProfit();
            if (li_Profit > li_MaxProfit) {
                li_MaxProfit = li_Profit;
                li_Index = i;
            }
            ++i;
        }
        return li_Index;
    }

    public int calculateTradeRoutes2(String as_Start, String as_Target, Vector av_Result, JProgressBar ao_ProgressBar) {
        ITradePoint lo_Start = this.getTradePoint(as_Start);
        ITradePoint lo_Target = this.getTradePoint(as_Target);
        return this.calculateTradeRoutes2(lo_Start, lo_Target, av_Result, ao_ProgressBar);
    }

    public int calculateTradeRoutes2(ITradePoint ao_Start, ITradePoint ao_Target, Vector av_Result, JProgressBar ao_ProgressBar) {
        Commodity lo_Commodity;
        boolean li_CalculatedRoutes = false;
        boolean li_CalculatedWays = false;
        int li_StartLocations = 0;
        int li_FinishedStartLocations = 0;
        av_Result.clear();
        Vector lv_Result = (Vector)this.mh_TradeRoutes.get(ao_Start.getName() + "-" + ao_Target.getName());
        if (lv_Result != null) {
            av_Result.addAll(lv_Result);
            return 0;
        }
        int li_FilteredTradeRoutes = 0;
        Vector lv_OfferedCommotidies = this.getOfferedCommotidiesForTradePoint(ao_Start);
        Hashtable<String, Vector> lh_StartList = new Hashtable<String, Vector>();
        int i = 0;
        while (i < lv_OfferedCommotidies.size()) {
            lo_Commodity = (Commodity)lv_OfferedCommotidies.get(i);
            lh_StartList.put(lo_Commodity.getName(), ao_Start.createLocationList(lo_Commodity.getName()));
            li_StartLocations += lh_StartList.size();
            ++i;
        }
        Hashtable<String, Vector> lh_TargetList = new Hashtable<String, Vector>();
        int i2 = 0;
        while (i2 < lv_OfferedCommotidies.size()) {
            lo_Commodity = (Commodity)lv_OfferedCommotidies.get(i2);
            lh_TargetList.put(lo_Commodity.getName(), ao_Target.createLocationList(lo_Commodity.getName(), lo_Commodity.getPrice()));
            ++i2;
        }
        if (ao_ProgressBar != null) {
            ao_ProgressBar.setMaximum(li_StartLocations);
        }
        int i3 = 0;
        while (i3 < lv_OfferedCommotidies.size()) {
            String ls_CommodityName = ((Commodity)lv_OfferedCommotidies.get(i3)).getName();
            Vector lv_StartLocations = (Vector)lh_StartList.get(ls_CommodityName);
            Vector lv_TargetLocations = (Vector)lh_TargetList.get(ls_CommodityName);
            int j = 0;
            while (j < lv_StartLocations.size()) {
                Location lo_StartLocation = (Location)lv_StartLocations.get(j);
                int k = 0;
                while (k < lv_TargetLocations.size()) {
                    Location lo_TargetLocation = (Location)lv_TargetLocations.get(k);
                    int li_PriceBuy = lo_StartLocation.getPrice();
                    int li_PriceSell = lo_TargetLocation.getPrice();
                    String ls_FactionStart = lo_StartLocation.getFactionName();
                    String ls_FactionTarget = lo_TargetLocation.getFactionName();
                    if (li_PriceSell > lo_StartLocation.getPrice()) {
                        if (this.mo_Filter == null || (!this.mo_Filter.hideFactions() || this.mo_Filter.acceptFaction(ls_FactionStart) && this.mo_Filter.acceptFaction(ls_FactionTarget)) && (!this.mo_Filter.hideCommodities() || this.mo_Filter.acceptCommodity(ls_CommodityName))) {
                            TradeRoute lo_TradeRoute = new TradeRoute(lo_StartLocation.getBaseName(), lo_TargetLocation.getBaseName(), ls_CommodityName, li_PriceBuy, li_PriceSell);
                            lo_TradeRoute.setStartFaction(ls_FactionStart);
                            lo_TradeRoute.setDestinationFaction(ls_FactionTarget);
                            Vector lv_Route = this.calcRoute(lo_StartLocation.getSystemName(), lo_TargetLocation.getSystemName(), this.mi_MapMode);
                            if (this.mo_Filter == null || !this.mo_Filter.hideLength() || this.mo_Filter.acceptLength(lv_Route.size())) {
                                lo_TradeRoute.setNumberOfSystems(lv_Route.size());
                                av_Result.add(lo_TradeRoute);
                            } else {
                                ++li_FilteredTradeRoutes;
                            }
                        } else {
                            ++li_FilteredTradeRoutes;
                        }
                    }
                    ++k;
                }
                ++li_FinishedStartLocations;
                if (ao_ProgressBar != null) {
                    ao_ProgressBar.setValue(li_FinishedStartLocations);
                }
                ++j;
            }
            ++i3;
        }
        this.mh_TradeRoutes.put(ao_Start.getName() + "-" + ao_Target.getName(), av_Result.clone());
        return li_FilteredTradeRoutes;
    }

    public void clearCache() {
        this.mh_TradeRouteChains.clear();
        this.mh_TradeRoutes.clear();
        this.mh_Routes.clear();
    }
}

