// FLutils.cpp

#include <time.h>
#include <stdio.h>

#include "FLutils.h"

const char gene[5] = "Gene";

//----------------------------------------------------------------------------
// Convert string to list of words
// (delimited by space, equals, comma, or end of line)
// - would have used istrstream, but it's broken in VC++ 6 :o(

varList::varList(std::string init)
{
    std::string temp = "";

    // Iterate through all chars in string
    for(unsigned i = 0; i < init.size(); i++) {
        if (strchr(" =,\r\n", init[i]) != NULL) {
            // If this char == delimiter, add word so far
            if (temp != "") {
                push_back(temp);
                temp = "";
            }
        } else {
            // Else append char to current word
            temp = temp + init[i];
        }
    }

    // Add last word to list
    if (temp != "")
        push_back(temp);
}

//----------------------------------------------------------------------------
// Get line from file, decoded as list of words
// Based on code pinched from "flcodec" by Jor <flcodec@jors.net>
// Original algorithm by Sherlog <sherlog@t-online.de>
// Includes code based on patch by Niwo to read decoded files

varList getFLline(FILE * file, bool decode, long &findex)
{
    std::string result = "";
    unsigned char d = 0;

    // Read file 1 char at a time, decoding as we go
    while (!feof(file) && d != '\n') {
        register int c = fgetc(file);
        if (c == EOF) break;

        if (decode) {
			// Decode Microsoft security... ;o)
			register unsigned char k = (gene[findex % 4] + findex) & 0xFF;
			d = c ^ (k | 0x80);
			findex++;
		} else {
			d = c;
		}

        // If current line is blank, read the next one instead
        if (d == '\n' && result == "") {
            d = 0;
            continue;
        }

        // If current line starts with "visit = ", skip to the next one
        // "visit = " appears an aweful lot in .fl files,
        //  so this gives us a considerable speed up
        if (d == '\n' && strncmp(result.c_str(), "visit = ", 8) == 0) {
            d = 0;
            result = "";
            continue;   
        }     

        // Append char to result
        result = result + (char) d;
    }

    // Return current line as a list of words
    return varList(result);
}

//----------------------------------------------------------------------------
// Converts group key to name (e.g. "li_n_grp" to "Navy")
// TODO: replace this with a more elegant solution, e.g. std::map

std::string convertGroup(std::string key)
{
    if (key == "")
        return "";
    else if (key == "li_n_grp")
        return "Navy";
    else if (key == "li_lsf_grp")
        return "LSF";
    else if (key == "fc_c_grp")
        return "Corsair";
    else if (key == "fc_ou_grp")
        return "Outcast";
    else
        return key;
}

// Convert 32 bit hex text into ASCII characters
// Produces HTML safe code, including <, > and &
// Unicode characters are replaced with HTML codes
std::string getTextFromHex(std::string hex)
{
    std::string text = "";

    const char * ptr = hex.c_str();
    char byte[5] = {0};

    // Use strtol to convert each block of 4 digits to a wide char
    for (unsigned int i = 0; i < hex.length(); i += 4, ptr += 4) {
		memcpy(byte, ptr, 4);
        wchar_t widechar = (wchar_t) strtol(byte, NULL, 16);
		text += getHTMLSafeChar(widechar);
    }

    return text;
}

//----------------------------------------------------------------------------
// Detect characters that aren't HTML safe, and convert them

std::string getHTMLSafeChar(wchar_t wc) {
	char temp[16];

	// Detect non-ASCII character, and insert HTML encoding for it (UNICODE)
	if (wc > 255) {
		sprintf(temp, "&#%i;", wc);
		return temp;
	}

  // Detect other dodgy characters, and replace with HTML codes
  switch (wc) {
    case '\r':	return "<BR>\n";
    case '<':	return "&lt;";
    case '>':	return "&gt;";	
    case '&':	return "&amp;";	
  }

	// Otherwise, return character as is
	sprintf(temp, "%c", wc);

	return temp;
}

//----------------------------------------------------------------------------
// Converts string of the form "mm/dd/yy HH:MM:SS" to type time_t

time_t getTimeFromText(std::string text)
{
    struct tm tmLogin = {0};

    sscanf(text.c_str(), "%02u/%02u/%02u %02u:%02u:%02u", 
        &tmLogin.tm_mon,  &tmLogin.tm_mday, &tmLogin.tm_year, 
        &tmLogin.tm_hour, &tmLogin.tm_min,  &tmLogin.tm_sec);
    tmLogin.tm_year += 100; // add 100 years to get into 21st centry
    tmLogin.tm_mon--;		// months count from 0
    tmLogin.tm_isdst = 1;	// enable DST to fix hours

    return mktime(&tmLogin);
}

//----------------------------------------------------------------------------
// Returns a number in the form 123,456,789

char *getCommaThousands(char *str, int number)
{
	if (number < 1000) {
		str+=sprintf(str, "%i", number);
	} else {
		str=getCommaThousands(str, number/1000);
		str+=sprintf(str, ",%03i", number%1000);
    }
	return str;
}

//----------------------------------------------------------------------------
