// FLoptions.cpp

#include <stdio.h>
#include <afxcoll.h>
#include <shlobj.h>
#include <winreg.h>

#include "FLoptions.h"
#include "FLutils.h"

//----------------------------------------------------------------------------
FLoptions::FLoptions()
: topNum(0), minRank(0), maxDays(0), activeHours(0), cheatLevel(10000),
  niceMs(10), sortKey("Rank"), withfile(true)
{
    // Code to find character files within "My Documents"
    LPITEMIDLIST pIDL;
    HRESULT hr = SHGetSpecialFolderLocation(0, CSIDL_PERSONAL , &pIDL);
    BOOL fRet  = SHGetPathFromIDList(pIDL, path);
	sprintf(path, "%s\\My Games\\Freelancer\\Accts\\Multiplayer", path);
}

//----------------------------------------------------------------------------
void FLoptions::loadConfig()
{
	FILE *input;
	char cfgfile[260];
	wchar_t buffer[255] = {0};
	int i;
	
	sprintf(cfgfile, "%s\\FLServer.cfg", path);
	
    if ((input = fopen(cfgfile, "rb")) == NULL) {
        return;
    }

	// 4 byte header
	fread(buffer, 2, 2, input);

	// Name: 32 wide characters + null (66 bytes)
	Name = "";
	fread(buffer, 2, 33, input);
	for (i = 0; i < 33 && buffer[i] != '\0'; i++)
		Name += getHTMLSafeChar(buffer[i]);

	// Description: 128 wide characters + null (258 bytes)
	Description = "";
	fread(buffer, 2, 129, input);
	for (i = 0; i < 129 && buffer[i] != '\0'; i++)
		Description += getHTMLSafeChar(buffer[i]);

	// Password: 17 wide characters + null (34 bytes)
	fread(buffer, 2, 17, input);
	Password = (*buffer != 0);

	// Allow New Players: bool (1 byte)
	fread(&AllowNew, 1, 1, input);

	// Internet: bool (1 byte)
	fread(&Internet, 1, 1, input);

	// Max Players: int (4 bytes)
	fread(&MaxPlayers, 4, 1, input);

	// PvP: bool (1 byte)
	fread(&AllowPvP, 1, 1, input);

	fclose(input);
}

//----------------------------------------------------------------------------
void FLoptions::print(FILE *hOutput, char *version) const
{
	fprintf(hOutput, "\n<!-- FLstat %s", version);
	if (topNum > 0)			fprintf(hOutput, " -top %i",	topNum);
	if (minRank > 0)		fprintf(hOutput, " -rank %i",	minRank);
	if (maxDays > 0)		fprintf(hOutput, " -days%i",	maxDays);
	if (activeHours > 0)	fprintf(hOutput, " -active %i",	activeHours);
	if (cheatLevel <= 999)	fprintf(hOutput, " -cheats %i",	cheatLevel);
	fprintf(hOutput, " -nice %i", niceMs);
	fprintf(hOutput, " -sort %s", sortKey.c_str());
	fprintf(hOutput, " -->\n");

	fprintf(hOutput, "<!-- FLServer: %s -->\n", Name.c_str());
	fprintf(hOutput, "<!-- MaxPlayers: %i -->\n", MaxPlayers);
}
//----------------------------------------------------------------------------
