// FLutils.h

#include <vector>
#include <string>

#define ONE_MIN  60					// 60 seconds
#define ONE_HOUR (ONE_MIN * 60)		// 60 minutes
#define ONE_DAY	 (ONE_HOUR * 24)	// 24 hours
#define TWO_DAYS (ONE_DAY * 2)		// 2 days

//----------------------------------------------------------------------------
// Class to convert a string to list of words

class varList : public std::vector<std::string>
{
public:
    varList(std::string init);
    ~varList() {;}
};
//----------------------------------------------------------------------------

// Get line from .fl file, decoded as list of words
varList getFLline(FILE * file, bool decode, long &findex);

// Convert 16 bit hex text into ASCII characters (HTML safe)
std::string getTextFromHex(std::string hex);

// Convert 32 bit hex text into UNICODE characters (HTML safe)
//std::wstring getWideTextFromHex(std::string hex);

// Detect characters that aren't HTML safe, and convert them
std::string getHTMLSafeChar(wchar_t wc);

// Converts string of the form "mm/dd/yy HH:MM:SS" to type time_t
time_t getTimeFromText(std::string text);

// Converts group key to name (e.g. "li_n_grp" to "Navy")
std::string convertGroup(std::string key);

// Returns a number in the form 123,456,789
char *getCommaThousands(char * str, int number);
