// FLstat.cpp : Freelancer Character Rankings Generator for the Web
// Copyright (C) 2003/2004 Tim Rigden (aka "Cryogenius")
// Email Address: flstat@cryosphere.co.uk

#define VERSION "v1.5"
#define HOMEPAGE "http://www.cryosphere.f2s.com/Freelancer/flstat.html"

#include <string.h>
#include <string>
#include <stdlib.h>
#include <malloc.h>
#include <stdio.h>
#include <direct.h>
#include <io.h>
#include <time.h>
#include <shlobj.h>

#include "FLchar.h"

// Prototypes
void printTable(FILE *hOutput, const FLoptions &options);
int loadChars(FLchars &charlist, const FLoptions &options);

//----------------------------------------------------------------------------
int main(int argc, char* argv[])
{
    fprintf(stderr, "- FLstat %s -\n", VERSION);

    // load options from .ini file into object
	FLoptions options;
    
    // Parse the command line options
    int argn = 1;
    while (argn < argc) {
        std::string opt(argv[argn++]);

        if (opt == "-top") {
            options.topNum = atoi(argv[argn++]);
        } else if (opt == "-rank") {
            options.minRank = atoi(argv[argn++]);
        } else if (opt == "-days") {
            options.maxDays = atoi(argv[argn++]);
        } else if (opt == "-path") {
            strcpy(options.path, argv[argn++]);
        } else if (opt == "-cheats") {
            options.cheatLevel = atoi(argv[argn++]);
        } else if (opt == "-active") {
            options.activeHours = atoi(argv[argn++]);
        } else if (opt == "-nice") {
            options.niceMs = atoi(argv[argn++]);
        } else if (opt == "-pos") {
            // ignore - no longer supported
        } else if (opt == "-nofile") {
            options.withfile = false;
        } else if (opt == "-sort") {
            options.sortKey = argv[argn++];
		} 
    }

	// Load name, description, etc from FLServer.cfg
	options.loadConfig();

	// Output table of characters
	printTable(stdout, options);

    fprintf(stderr, "Done!\n\n");

    return 0;
}

//----------------------------------------------------------------------------
void printTable(FILE *hOutput, const FLoptions &options)
{
    FLchars charlist;  
    time_t stime, ftime;
    
    // Start timing...
    time(&stime);

    fprintf(stderr, "Reading character files...\n");

    // Search for all character files, and load them
    int chars = loadChars(charlist, options);
    if (chars == 0) {
		fprintf(stderr, "No characters could be loaded.\n");
        return;
	}

    fprintf(stderr, "Sorting %i characters...\n", charlist.size());

    // Sort characters rank, money, kills, time or login
    charlist.sort();

    fprintf(stderr, "Generating output...\n", charlist.size());

	options.print(hOutput, VERSION);
    fprintf(hOutput, "<!-- Chars total %i active %i -->\n", chars, charlist.size());

    // Print out each character in HTML table
    int pos = 1;
    for(FLchars::iterator iter = charlist.begin(); iter != charlist.end(); iter++) {
        iter->print(hOutput, pos++, options);
        if (options.topNum > 0 && pos > options.topNum) break;
    }

    // Stop the clock!
    time(&ftime); 

    // Output footer line, with time and version
	char timeStr[64];
	struct tm *today;
	today = localtime(&ftime);
	strftime(timeStr, 64, "%a %b %d %X %Y", today);

    fprintf(hOutput, "<TR CLASS=\"Footer\">\n");
    fprintf(hOutput, "\t<TD COLSPAN=\"11\" ALIGN=\"CENTER\"><I>- Last updated on <B>%s</B>", timeStr);
    fprintf(hOutput, " - Generated by <A HREF=\"%s\"><b>FLstat %s</b></A>, in %lu secs -</I></TD>\n", HOMEPAGE, VERSION, (int) ftime - stime);
    fprintf(hOutput, "</TR>\n");
}


//----------------------------------------------------------------------------
int loadChars(FLchars &charlist, const FLoptions &options)
{
    struct _finddata_t subdir;
    long hFile1;
    int chars = 0;

	// chdir to where the character files are stored
    if (!SetCurrentDirectory(options.path)) {
        fprintf(stderr, "Could not access directory: %s\n", options.path);
        return 0;
    }

    // Find first file in current directory
    if( (hFile1 = _findfirst( "*", &subdir )) == -1L ) {
        return 0;
    }

    int status1 = 0;
    while (status1 == 0) {
        if (subdir.attrib & _A_SUBDIR && strlen(subdir.name) > 3 ) {
            struct _finddata_t fl_file;
            long hFile2;

            SetCurrentDirectory(subdir.name);

            // Look for "banned" file, and skip this account if it exists
            if( (_access("banned", 0)) == -1 ) {

                // Find first .fl file... if there isn't one then ignore it.
                if( (hFile2 = _findfirst( "*.fl", &fl_file )) != -1L ) {
                    int status2 = 0;

                    // Load character into memory, and then find next .fl file
                    while (status2 == 0) {
                        chars++;
                        FLchar character(subdir.name, fl_file.name, options.sortKey);

                        // Only add character if they are active
                        if (character.Active(options))
                            charlist.push_back(character);
                        status2 = _findnext( hFile2, &fl_file );
                        
						// Reduce CPU usage
						Sleep(options.niceMs);
                    }

                    _findclose(hFile2);
                }
            }

            fprintf(stderr, "+ %i\r", chars);

            SetCurrentDirectory("..");
        }

        // Find the next of the subdir
        status1 = _findnext( hFile1, &subdir );
    }

    _findclose(hFile1);

    return chars;
}
