// FLoptions.h

#include <string>
//#include <wchar.h>

//----------------------------------------------------------------------------
class FLoptions
{
public:
	// FLstat options, extracted from FLstat.ini
	int		topNum;				// Show only top N characters
	int		minRank;			// Show only characters at rank N or higher
	int		maxDays;			// Show only characters which have played within the last N days
	int		activeHours;		// Highlight characters that have logged in within the last N hours
	int		cheatLevel;			// Highlight cheaters, where N is the sensitivity (e.g. 30)
	int		niceMs;				// Run with lower CPU usage, for example: -nice 50 (default 10)
	//bool	longFormat;			// Includes missions completed and bases/systems/holes visited
	//char	templatefile[1024];	// Filename of template file
	//char	outputfile[1024];	// Filename of output file
	char 	path[1024];			// Override the default location of the Multiplayer Accounts
	bool	withfile;			// If false, then the File: comment will be suppressed from output

	std::string	sortKey;

	// The following parameters are extracted from FLServer.cfg
	std::string	Name;		// Server Name
	std::string	Description;// Server Description
	bool	Password;			// True if a password has been set
	bool	AllowNew;			// True if new characters can be created
	bool	Internet;			// True if server is listed on the Global List
	bool	AllowPvP;			// True if player killing is allowed
	int		MaxPlayers;			// Maximum number of players at one time

	// Constructor
	FLoptions();

	// Member functions
	//bool loadSection(const char *section);
	void loadConfig();

	//size_t printParameter(FILE *hOutput, char *start) const;
	void print(FILE *hOutput, char *version) const;
};

