// FLchar.h

#include <string>
#include <list>
#include <ostream.h>
#include <stdio.h>

#include "FLutils.h"
#include "FLoptions.h"

//----------------------------------------------------------------------------
// Single character class

class FLchar
{
private:
    std::string dir;
    std::string file;
    std::string name;
    std::string description;
    std::string group;
    int         rank;
    int         money;
    int         kills;
    int         missions;
    int         failed;
    time_t      timeOnline;
    int         systems;
    int         bases;
    int         holes;
    time_t      timeLogin;

	std::string sortKey;

public:
	// Constructor
    FLchar(char * directory, char * filename, std::string sort);
    ~FLchar() {;}
    
	// Returns false if character has never logged in, 
	// has a rank below minRank, or logged in more than maxDays ago
    bool Active(const FLoptions &options);

	// Comparison operator, used for sort function
    bool operator< (FLchar other);

	// Print character
    void print(FILE *hOutput, int position, const FLoptions &options);
};

//----------------------------------------------------------------------------
// List of FLchars

class FLchars : public std::list<FLchar>
{
public:
    typedef std::list<FLchar>::iterator iterator;
    
    FLchars() {;}
    ~FLchars() {;}
};
