#ifndef _SERVER_
#define _SERVER_
#include <vector>

class Vector
{
public:
	float x,y,z;
};

class Matrix
{
public:
	float data[3][3];
};

struct CHAT_ID
{
	int iID;
};

enum DestroyType
{
	DT_TEST = 2,
};

namespace pub { 
	struct CargoEnumerator;
	namespace Player {
		IMPORT int __cdecl InspectCash(unsigned int const &,int &);
		IMPORT int __cdecl AdjustCash(unsigned int const &,int);
		IMPORT int __cdecl ForceLand(unsigned int,unsigned int);
		IMPORT int __cdecl PopUpDialog(unsigned int,struct FmtStr const &,struct FmtStr const &,unsigned int);
		IMPORT int __cdecl DisplayMissionMessage(unsigned int const &,struct FmtStr const &,enum  MissionMessageType,bool);
		IMPORT int __cdecl GetLocation(unsigned int const &,unsigned int &);
		IMPORT int __cdecl GetSystem(unsigned int const &,unsigned int &);
		IMPORT int __cdecl GetBase(unsigned int const &,unsigned int &);
		IMPORT int __cdecl GetShip(unsigned int const &,unsigned int &);
		IMPORT int __cdecl GetShipID(unsigned int const &,unsigned int &);
		IMPORT int __cdecl GetMsnID(unsigned int,unsigned int &);
		IMPORT int __cdecl EnumerateCargo(unsigned int const &,struct pub::CargoEnumerator &);
		IMPORT int __cdecl RemoveCargo(unsigned int const &,unsigned short,unsigned int);
		IMPORT int __cdecl AddCargo(unsigned int const &,unsigned int const &,unsigned int,float,bool);
		IMPORT int __cdecl GetRemainingHoldSize(unsigned int const &,float &);
		IMPORT int __cdecl GetMoneyNeededToNextRank(unsigned int const &,int &);
		IMPORT int __cdecl GetNumKills(unsigned int const &,int &);
		IMPORT int __cdecl SetNumKills(unsigned int const &,int);
		IMPORT int __cdecl ReturnPlayerStats(unsigned int,unsigned char *,int);
		IMPORT int __cdecl GetRep(unsigned int const &,int &);
		IMPORT int __cdecl GetGroupMembers(unsigned int,std::vector<unsigned int> &);
	}

	namespace GF {
		IMPORT unsigned int __cdecl FindBase(char const *);
	}

	namespace SpaceObj {
		IMPORT int __cdecl GetHealth(unsigned int const &,float &,float &);
		IMPORT int __cdecl GetArchetypeID(unsigned int const &,unsigned int &);
		IMPORT int __cdecl GetGoodID(unsigned int const &,unsigned int &);
		IMPORT int __cdecl GetSolarArchetypeNickname(char *,int,unsigned int);
		IMPORT int __cdecl GetType(unsigned int,unsigned int &);
		IMPORT int __cdecl GetSolarArchetypeID(unsigned int,unsigned int &);
		IMPORT int __cdecl GetSolarParent(unsigned int const &,unsigned int &);
		IMPORT int __cdecl Destroy(unsigned int,enum  DestroyType);
		IMPORT int __cdecl SetRelativeHealth(unsigned int const &,float);
		IMPORT int __cdecl GetLocation(unsigned int,class Vector &,class Matrix &);
		IMPORT int __cdecl Relocate(unsigned int const &,unsigned int const &,class Vector const &,class Matrix const &);
		IMPORT int __cdecl GetMotion(unsigned int,class Vector &,class Vector &);
		IMPORT int __cdecl GetRep(unsigned int,int &);
		IMPORT int __cdecl GetSolarRep(unsigned int,int &);
	}

	namespace Market {
		IMPORT int __cdecl GetPrice(unsigned int,unsigned int,float &);
		IMPORT int __cdecl GetCommoditiesForSale(unsigned int,unsigned int * const,int *);
	}

	namespace Reputation {
		IMPORT int __cdecl GetAttitude(int const &,int const &,float &);
		IMPORT int __cdecl GetGroupFeelingsTowards(int const &,unsigned int const &,float &);
		IMPORT int __cdecl GetReputation(int &,char const *);
		IMPORT int __cdecl GetGroupName(unsigned int const &,unsigned int &);
		IMPORT int __cdecl GetReputationGroup(unsigned int &,char const *);
		IMPORT int __cdecl GetAffiliation(int const &,unsigned int &);
		IMPORT int __cdecl SetAttitude(int const &,int const &,float);
		IMPORT int __cdecl SetReputation(int const &,unsigned int const &,float);
		IMPORT int __cdecl SetReputation(unsigned int const &,unsigned int const &,float);
	}

	IMPORT int Save(unsigned int,unsigned int);
	IMPORT int GetBaseID(unsigned int &,char const *);
	IMPORT int GetSystemID(unsigned int &,char const *);
	IMPORT unsigned int __cdecl GetBaseNickname(char *,unsigned int,unsigned int const &);
	IMPORT int __cdecl GetBaseStridName(unsigned int &,unsigned int const &);
	IMPORT unsigned int __cdecl GetSystemNickname(char *,unsigned int,unsigned int const &);
	IMPORT int __cdecl GetShipID(unsigned int &,char const *);
	IMPORT int __cdecl GetGoodID(unsigned int &,char const *);
	IMPORT int __cdecl IsCommodity(unsigned int const &,bool &);
	IMPORT int __cdecl GetBases(unsigned int const &,unsigned int * const,unsigned int,unsigned int &);
}

struct SSPMunitionCollisionInfo
{
	uint iProjectileArchID;
	DWORD dw2;
	DWORD dwTargetShip;
	short s1;
};

struct SSPObjCollisionInfo
{
	DWORD dwTargetShip;
};

struct XActivateEquip
{
	long	l1;
	ushort	sID;
	bool	bActivate;
};

struct XActivateCruise
{
	long	l1;
	bool	bActivate;
};

struct XActivateThrusters
{
	long	l1;
	bool	bActivate;
};

struct SGFGoodSellInfo
{
	long	l1;
	uint	iArchID;
	int		iCount;
};

struct SGFGoodBuyInfo
{
	uint iBaseID;;
	ulong lNull;
	uint iGoodID;
	int iCount;
};

struct XFireWeaponInfo
{
	uint iDunno1;
	Vector vDirection;
	uint iDunno2;
	short *sArray1;
	short *sArray2;
	short *s3;
};

struct SSPObjUpdateInfo
{
	float f[9];
	uint i;
};

struct IMPORT IServerImpl
{
public:
	virtual void AbortMission(unsigned int,unsigned int);
	virtual void AcceptTrade(unsigned int,bool);
	virtual void ActivateCruise(unsigned int,struct XActivateCruise const &);
	virtual void ActivateEquip(unsigned int,struct XActivateEquip const &);
	virtual void ActivateThrusters(unsigned int,struct XActivateThrusters const &);
	virtual void AddTradeEquip(unsigned int,struct EquipDesc const &);
	virtual void BaseEnter(unsigned int,unsigned int);
	virtual void BaseExit(unsigned int,unsigned int);
	virtual void BaseInfoRequest(unsigned int,unsigned int,bool);
	virtual void CharacterInfoReq(unsigned int,bool);
	virtual void CharacterSelect(struct CHARACTER_ID const &,unsigned int);
	virtual void CharacterSkipAutosave(unsigned int);
	virtual void CommComplete(unsigned int,unsigned int,unsigned int,enum  CommResult);
	virtual void Connect(char const *,unsigned short *);
	virtual void CreateNewCharacter(struct SCreateCharacterInfo const &,unsigned int);
	virtual void DelTradeEquip(unsigned int,struct EquipDesc const &);
	virtual void DestroyCharacter(struct CHARACTER_ID const &,unsigned int);
	virtual void DisConnect(unsigned int,enum  EFLConnection);
	virtual void Dock(unsigned int const &,unsigned int const &);
	virtual void DumpPacketStats(char const *);
	virtual void ElapseTime(float);
	virtual void FireWeapon(unsigned int,struct XFireWeaponInfo const &);
	virtual void GFGoodBuy(struct SGFGoodBuyInfo const &,unsigned int);
	virtual void GFGoodSell(struct SGFGoodSellInfo const &,unsigned int);
	virtual void GFGoodVaporized(struct SGFGoodVaporizedInfo const &,unsigned int);
	virtual void GFObjSelect(unsigned int,unsigned int);
	virtual unsigned int GetServerID(void);
	virtual char const * GetServerSig(void);
	void GetServerStats(struct ServerStats &);
	virtual void GoTradelane(unsigned int,struct XGoTradelane const &);
	virtual void Hail(unsigned int,unsigned int,unsigned int);
	virtual void InitiateTrade(unsigned int,unsigned int);
	virtual void InterfaceItemUsed(unsigned int,unsigned int);
	virtual void JettisonCargo(unsigned int,struct XJettisonCargo const &);
	virtual void JumpInComplete(unsigned int,unsigned int);
	virtual void LaunchComplete(unsigned int,unsigned int);
	virtual void LocationEnter(unsigned int,unsigned int);
	virtual void LocationExit(unsigned int,unsigned int);
	virtual void LocationInfoRequest(unsigned int,unsigned int,bool);
	virtual void Login(struct SLoginInfo const &,unsigned int);
	virtual void MineAsteroid(unsigned int,class Vector const &,unsigned int,unsigned int,unsigned int,unsigned int);
	virtual void MissionResponse(unsigned int,unsigned long,bool,unsigned int);
	virtual void MissionSaveB(unsigned int,unsigned long);
	virtual void NewCharacterInfoReq(unsigned int);
	virtual void OnConnect(unsigned int);
	virtual void PlayerLaunch(unsigned int,unsigned int);
	virtual void PushToServer(class CDAPacket *);
	virtual void PopUpDialog(unsigned int,unsigned int);
	virtual void RTCDone(unsigned int,unsigned int);
	virtual void ReqAddItem(unsigned int,char const *,int,float,bool,unsigned int);
	virtual void ReqCargo(class EquipDescList const &,unsigned int);
	virtual void ReqChangeCash(int,unsigned int);
	virtual void ReqCollisionGroups(class std::list<struct CollisionGroupDesc,class std::allocator<struct CollisionGroupDesc> > const &,unsigned int);
	virtual void ReqDifficultyScale(float,unsigned int);
	virtual void ReqEquipment(class EquipDescList const &,unsigned int);
	virtual void ReqHullStatus(float,unsigned int);
	virtual void ReqModifyItem(unsigned short,char const *,int,float,bool,unsigned int);
	virtual void ReqRemoveItem(unsigned short,int,unsigned int);
	virtual void ReqSetCash(int,unsigned int);
	virtual void ReqShipArch(unsigned int,unsigned int);
	virtual void RequestBestPath(unsigned int,unsigned char *,int);
	virtual void RequestCancel(int,unsigned int,unsigned int,unsigned long,unsigned int);
	virtual void RequestCreateShip(unsigned int);
	virtual void RequestEvent(int,unsigned int,unsigned int,unsigned int,unsigned long,unsigned int);
	virtual void RequestGroupPositions(unsigned int,unsigned char *,int);
	virtual void RequestPlayerStats(unsigned int,unsigned char *,int);
	virtual void RequestRankLevel(unsigned int,unsigned char *,int);
	virtual void RequestTrade(unsigned int,unsigned int);
	virtual void SPBadLandsObjCollision(struct SSPBadLandsObjCollisionInfo const &,unsigned int);
	virtual void SPMunitionCollision(struct SSPMunitionCollisionInfo const &,unsigned int);
	virtual void SPObjCollision(struct SSPObjCollisionInfo const &,unsigned int);
	virtual void SPObjUpdate(struct SSPObjUpdateInfo const &,unsigned int);
	virtual void SPRequestInvincibility(unsigned int,bool,enum  InvincibilityReason,unsigned int);
	virtual void SPRequestUseItem(struct SSPUseItem const &,unsigned int);
	virtual void SPScanCargo(unsigned int const &,unsigned int const &,unsigned int);
	virtual void SaveGame(struct CHARACTER_ID const &,unsigned short const *,unsigned int);
	virtual void SetActiveConnection(enum  EFLConnection);
	virtual void SetInterfaceState(unsigned int,unsigned char *,int);
	virtual void SetManeuver(unsigned int,struct XSetManeuver const &);
	virtual void SetMissionLog(unsigned int,unsigned char *,int);
	virtual void SetTarget(unsigned int,struct XSetTarget const &);
	virtual void SetTradeMoney(unsigned int,unsigned long);
	virtual void SetVisitedState(unsigned int,unsigned char *,int);
	virtual void SetWeaponGroup(unsigned int,unsigned char *,int);
	virtual void Shutdown(void);
	virtual bool Startup(struct SStartupInfo const &);
	virtual void StopTradeRequest(unsigned int);
	virtual void StopTradelane(unsigned int,unsigned int,unsigned int,unsigned int);
	virtual void SubmitChat(struct CHAT_ID,unsigned long,void const *, struct CHAT_ID,int);
	virtual void SystemSwitchOutComplete(unsigned int,unsigned int);
	virtual void TerminateTrade(unsigned int,int);
	virtual void TractorObjects(unsigned int,struct XTractorObjects const &);
	virtual void TradeResponse(unsigned char const *,int,unsigned int);
	virtual int Update(void);
};

//?PopUpDialog@Player@pub@@YAHIABUFmtStr@@0I@Z
//?PopUpDialog@Player@pub@@YAHIABUFmtStr@@II@Z

class IMPORT CAccount
{
public:
	void ForceLogout(void);
	void DeleteCharacterFromID(std::basic_string<char> &);
	void InitFromFolder(char const *);
};

struct PlayerData
{
//	ulong lArray[262];
	ulong lArray1[153];
	ulong lShipArchID;
	ulong lArray2[108];
};

class IMPORT PlayerDB
{
public:
	struct PlayerData & operator[](unsigned int const &);
	bool BanAccount(flstr &,bool);
	class CAccount* FindAccountFromCharacterName(flstr &);
	struct PlayerData * traverse_active(struct PlayerData *)const;
	unsigned short const * GetActiveCharacterName(unsigned int)const;
	class CAccount * FindAccountFromClientID(unsigned int);
	bool GetAccountAdminRights(flstr &);
	unsigned int GetMaxPlayerCount(void);
	unsigned char login(struct SLoginInfo const &,unsigned int);
	bool DeleteCharacterFromName(std::basic_string<unsigned short,struct ci_wchar_traits> &);
	void DeleteCharacterFromID(std::basic_string<char> &);
	void logout(unsigned int);
	void LockAccountAccess(std::basic_string<unsigned short,struct ci_wchar_traits> &);
	void UnlockAccountAccess(std::basic_string<unsigned short,struct ci_wchar_traits> &);
private:
	unsigned char load_user_data(struct SLoginInfo const &,unsigned int);
};
#endif