#ifndef _GLOBAL_
#define _GLOBAL_
#pragma warning(disable: 4311 4786)

// includes 
#include <windows.h>
#include <stdio.h>
#include <string>
#include <list>
using namespace std;

// defines
#define VERSION L"1.5.5"

#define TIME_UPDATE 50
#define IMPORT __declspec(dllimport)
#define foreach(lst, type, var) for(list<type>::iterator var = lst.begin(); (var != lst.end()); var++)
#define foreachreverse(lst, type, var) for(list<type>::reverse_iterator var = lst.rbegin(); (var != lst.rend()); var++)
#define LOG_ENTER() { if(set_iDebug >= 3) AddLog(__FUNCTION__ " stepin"); }
#define LOG_RETURN(a) { if(set_iDebug >= 3) AddLog(__FUNCTION__ " return: " #a); return a; }
#define LOG_RETURN_S(a) { \
	if(set_iDebug >= 3) {\
		char szBuf[1024]; \
		sprintf(szBuf, __FUNCTION__ " return: %s", a); \
		AddLog(szBuf); \
	} \
	return a;  \
	}
#define LOG_RETURN_WS(a) { \
	if(set_iDebug >= 3) {\
		string scStr = wstos(a); \
		char szBuf[1024]; \
		sprintf(szBuf, __FUNCTION__ " return: %s", scStr.c_str()); \
		AddLog(szBuf); \
	} \
	return a;  \
	}
#define LOG_RETURN_I(a) { \
	if(set_iDebug >= 3) {\
		char szBuf[1024]; \
		sprintf(szBuf, __FUNCTION__ " return: %d", (int)a); \
		AddLog(szBuf); \
	} \
	return a;  \
	}

#define LOG_LEAVE() if(set_iDebug >= 3) AddLog(__FUNCTION__ " stepout");

// typedefs
typedef unsigned int uint;
typedef unsigned char uchar;
typedef unsigned short ushort;
typedef unsigned long ulong;
typedef unsigned __int64 mstime;

// custom fl wstring
#if _MSC_VER == 1200
// vc6
	#define __FUNCSIG__ __FUNCTION__ // not supported
	typedef class std::basic_string<unsigned short,struct ci_wchar_traits> flstr;
	typedef class std::basic_string<char,struct ci_char_traits> flstrs;
#else
// vc7
	typedef class std::basic_string<unsigned short,struct ci_wchar_traits> flstr;
	typedef class std::basic_string<char,struct ci_char_traits> flstrs;
#endif

typedef flstr* (*_CreateWString)(const wchar_t *wszStr);
typedef void (*_FreeWString)(flstr *wscStr);
typedef flstrs* (*_CreateString)(const char *szStr);
typedef void (*_FreeString)(flstrs *scStr);

// structures
struct INISECTIONVALUE
{
	string scKey;
	string scValue;
};

struct MULTIKILLMESSAGE
{
	uint iKillsInARow;
	wstring wscMessage;
};

// functions
bool FLHookInit();
void FLHookInitUnload();
void FLHookUnload();
void ProcessEvent(wstring wscText, ...);
void LoadSettings();
void ProcessPendingCommands();

// tools
wstring stows(string scText);
string wstos(wstring wscText);
string itos(int i);
string IniGetS(string scFile, string scApp, string scKey, string scDefault);
int IniGetI(string scFile, string scApp, string scKey, int iDefault);
bool IniGetB(string scFile, string scApp, string scKey, bool bDefault);
void IniWrite(string scFile, string scApp, string scKey, string scValue);
void WriteProcMem(void *pAddress, void *pMem, int iSize);
void ReadProcMem(void *pAddress, void *pMem, int iSize);
wstring ToLower(wstring wscStr);
string ToLower(string scStr);
int ToInt(wstring wscStr);
void ConPrint(wstring wscText, ...);
void AddLog(const char *szString, ...);
wstring XMLText(wstring wscText);
wstring GetParam(wstring wscLine, wchar_t wcSplitChar, uint iPos);
wstring ReplaceStr(wstring wscSource, wstring wscSearchFor, wstring wscReplaceWith);
void IniDelSection(string scFile, string scApp);
void IniWriteW(string scFile, string scApp, string scKey, wstring wscValue);
wstring IniGetWS(string scFile, string scApp, string scKey, wstring wscDefault);
wstring ToMoneyStr(int iCash);
float IniGetF(string scFile, string scApp, string scKey, float fDefault);
void IniGetSection(string scFile, string scApp, list<INISECTIONVALUE> &lstValues);
float ToFloat(wstring wscStr);
mstime timeInMS();

// variables
extern HANDLE hProcFL;
extern HMODULE hModServer;
extern HMODULE hModCommon;
extern HMODULE hModRemoteClient;
extern HMODULE hModDPNet;
extern HMODULE hModDaLib;
extern HMODULE hModContent;
extern _CreateWString CreateWString;
extern _FreeWString FreeWString;
extern _CreateString CreateString;
extern _FreeString FreeString;
extern FILE *fLog;
extern FARPROC fpOldUpdate;

// setting variables
extern string set_scCfgFile;
extern uint set_iAntiDockKill;
extern list<uint> set_lstNoPVPSystems;
extern list<wstring> set_lstChatSuppress;
extern bool set_bSocketActivated;
extern int set_iDebug;
extern wstring set_wscDeathMsgStyle;
extern wstring set_wscDeathMsgStyleSys;
extern bool	set_bDieMsg;
extern bool	set_bDisableCharfileEncryption;
extern uint	set_iAntiBaseIdle;
extern uint	set_iAntiCharMenuIdle;
extern bool set_bChangeCruiseDisruptorBehaviour;
extern bool	set_bUserCmdSetDieMsg;
extern bool	set_bUserCmdSetChatFont;
extern uint	set_iPingKickFrame;
extern uint	set_iPingKick;
extern uint	set_iLossKickFrame;
extern uint	set_iLossKick;
extern bool	set_bUserCmdIgnore;
extern uint	set_iDisableNPCSpawns;
extern int	set_iPort;
extern int	set_iWPort;
extern wstring set_wscKickMsg;
extern wstring set_wscUserCmdStyle;
extern wstring set_wscAdminCmdStyle;
extern uint	set_iKickMsgPeriod;
extern wstring set_wscDeathMsgTextPlayerKill;
extern wstring set_wscDeathMsgTextSelfKill;
extern wstring set_wscDeathMsgTextNPC;
extern wstring set_wscDeathMsgTextSuicide;
extern uint	set_iAntiF1;
extern wstring set_wscDeathMsgTextAdminKill;
extern uint	set_iUserCmdMaxIgnoreList;
extern uint	set_iReservedSlots;
extern uint	set_iDisconnectDelay;
extern bool	set_bAutoBuy;
extern float set_fTorpMissileBaseDamageMultiplier;
extern bool set_MKM_bActivated;
extern wstring set_MKM_wscStyle;
extern list<MULTIKILLMESSAGE> set_MKM_lstMessages;
extern bool	set_bUserCmdSetDieMsgSize;
extern uint	set_iMaxGroupSize;
extern list<wstring> set_lstBans;
extern bool	set_bBanAccountOnMatch;

extern uint	set_iCloakWarmup;
extern uint	set_iCloakLimit;
extern bool	set_bUnCloakOnDmg;
extern list<INISECTIONVALUE> set_lstCloakDevices;


#endif
