#include <map>
#ifndef _COMMON_
#define _COMMON_

IMPORT unsigned int __cdecl Arch2Good(unsigned int);
IMPORT bool __cdecl GetUserDataPath(char * const);
IMPORT unsigned int __cdecl CreateID(char const *);

class IMPORT BinaryRDLWriter
{
	char szBuf[1024];

public:
	BinaryRDLWriter(class BinaryRDLWriter const &);
	BinaryRDLWriter(void);
	class BinaryRDLWriter & operator=(BinaryRDLWriter const &);
	virtual bool write_buffer(class RenderDisplayList const &,char *,unsigned int,unsigned int &);
	virtual bool write_file(class RenderDisplayList const &,char const *);
};

class IMPORT BinaryRDLReader
{
	char szBuf[1024];

public:
	BinaryRDLReader(class BinaryRDLReader const &);
	BinaryRDLReader(void);
	virtual bool extract_text_from_buffer(unsigned short *,unsigned int,unsigned int &,char const *,unsigned int);
	class BinaryRDLReader & operator=(class BinaryRDLReader const &);
	virtual bool read_buffer(class RenderDisplayList &,char const *,unsigned int);
	virtual bool read_file(class RenderDisplayList &,char const *);
};

class IMPORT TextNode
{
	char szBuf[1024];
public:
	TextNode(unsigned short const *,int);
};


namespace Universe {
	struct IBase
	{
		ulong l1[10];
		ulong lSpaceObjID;
	};
	IMPORT struct IBase * __cdecl GetFirstBase(void);
	IMPORT struct IBase * __cdecl GetNextBase(void);
	IMPORT struct IBase * __cdecl get_base(unsigned int);
	IMPORT unsigned int __cdecl get_base_id(char const *);
}

struct IMPORT FmtStr
{
	char szBuf[0xFFFF];

public:
	struct Val
	{
	char szBuf[0xFFFF];

	private: 
		int InitFromVoid(void const *);
	public:
		Val(unsigned short,void *,unsigned char);
		Val(void const *);
		Val(void const *,int &);
		unsigned int flatten(void *,unsigned int)const;
		unsigned int get_flattened_size(void)const;
		static void __cdecl operator delete(void *);
		static void * __cdecl operator new(unsigned int); // jmp to malloc
		~Val(void);
	};
 
	FmtStr(struct FmtStr const &);
	FmtStr(unsigned int, struct Val const *);
	struct FmtStr const & operator=(struct FmtStr const &);
	bool operator==(struct FmtStr const &)const ;
	void append(struct FmtStr::Val *);
	void append_base(unsigned int const &);
	void append_fmt_str(struct FmtStr const &);
	void append_good(unsigned int const &);
	void append_installation(int);
	void append_int(unsigned int);
	void append_loot(int);
//	void append_nav_marker(struct FmtStr::NavMarker const &);
	void append_rep_group(unsigned int const &);
	void append_rep_instance(int const &);
	void append_spaceobj_id(unsigned int const &);
	void append_string(unsigned int);
	void append_system(unsigned int const &);
	int append_void(void *);
	void append_zone_id(unsigned int const &);
	void destroy(void);
	int flatten(void *,unsigned int)const;
	int unflatten(void *,unsigned int);
	void begin_mad_lib(unsigned int);
	void end_mad_lib(void);
	~FmtStr(void);
};

struct IMPORT DamageEntry
{
	char szBuf[1024];

public:
	enum SubObjFate {};
	DamageEntry(void);
	static char const * __cdecl FateToString(enum  SubObjFate);
	bool operator!=(struct DamageEntry const &)const;
	bool operator<(struct DamageEntry const &)const;
	struct DamageEntry & operator=(struct DamageEntry const &);
	bool operator==(struct DamageEntry const &)const;
	bool operator>(struct DamageEntry const &)const;
};

struct IMPORT DamageList
{
	char szBuf[1024];
public:
	DamageList(struct DamageList const &);
	DamageList(void);
	~DamageList(void);

	static char const * __cdecl DmgCauseToString(enum  DamageCause);
	void add_damage_entry(unsigned short,float,enum  DamageEntry::SubObjFate);
	enum  DamageCause get_cause(void)const;
	float get_hit_pts_left(unsigned short)const;
	unsigned int get_inflictor_id(void)const;
	unsigned int get_inflictor_owner_player(void)const;
	bool is_destroyed(void)const;
	bool is_inflictor_a_player(void)const;
	struct DamageList & operator=(struct DamageList const &);
	void set_cause(enum  DamageCause);
	void set_destroyed(bool);
	void set_inflictor_id(unsigned int);
	void set_inflictor_owner_player(unsigned int);

};

class IMPORT RenderDisplayList
{
	char szBuf[1024];
	public:
		RenderDisplayList(void);
		~RenderDisplayList(void);
};

struct IMPORT XMLReader
{
	char szBuf[1024];
public:
	virtual bool read_buffer(class RenderDisplayList &,char const *,unsigned int);
	virtual bool read_file(class RenderDisplayList &,char const *);
};

struct GoodInfo
{
	uint i1;
	uint iLen;
	char szBuf[64];
	uint ArchID;
	uint type; // == 0 when commodity
	uint i3;
	char szBuf2[13*4];
	uint iIDS;
};

namespace GoodList 
{
	IMPORT struct GoodInfo const * __cdecl find_by_id(unsigned int);
	IMPORT struct GoodInfo const * __cdecl find_by_archetype(unsigned int);
};

struct /*IMPORT*/ EquipDesc
{
	public: 
		ushort dunno; // 00
		ushort id; // 02
		ulong archid; // 04
		ulong hardpoint; // 08
		bool equipped; //0Ch
		ulong status; //10h
		ulong count; //14h
		bool temporary; //18h
		ulong owner; //01Ch

//		unsigned short get_id(void)const;
};

class IMPORT EquipDescList
{
	public: 
		int add_equipment_item(struct EquipDesc const &,bool);
		struct EquipDesc const * find_equipment_item(unsigned short)const;
		struct EquipDesc const * find_matching_cargo(unsigned int,int,float)const;
		int remove_equipment_item(unsigned short,int);
};

enum HpAttachmentType;

namespace Archetype
{
	struct IMPORT Ship
	{
		ulong lArray[80];
		ulong lMaxNanobots;
		ulong lMaxShieldBats;
	};

	struct Equipment
	{
		uint iVFTable;
		uint i2;
		uint i3;
		char *szName;
		uint i5;
		uint iIDSName;
		uint iIDSInfo; 
		uint iArray[16];
		float fVolume;
		uint iArray2[14];
		uint iAmmoArchID; // 39
		uint iArray3[67];
		uint iGunTypeFlags;
		uint iDunno;
		uint iGunType;
		uint iArray4[50];
//		uint i[152];
	};

	IMPORT struct Ship * __cdecl GetShip(unsigned int);
	IMPORT struct Archetype::Equipment * __cdecl GetEquipment(unsigned int);

	class IMPORT Gun 
	{
	public: 
//		virtual enum  HpAttachmentType get_hp_type(void)const;
		int get_number_of_hp_types(void)const;
		enum HpAttachmentType get_hp_type_by_index(int)const;
	};
}

struct MarketGoodInfo
{
	u_long lArray[16];
};

class IMPORT BaseDataList
{
public:
	class BaseData * get_base_data(unsigned int)const;
};

class BaseDataList * __cdecl BaseDataList_get(void);

class IMPORT BaseData
{
public: 
	class std::map<unsigned int,struct MarketGoodInfo,struct std::less<unsigned int>,class std::allocator<struct MarketGoodInfo> > const * get_market(void)const;
};

class IMPORT CSimple
{
public:
	float get_hit_pts(void)const;
};

class IMPORT CShip
{
public:
	bool is_cruise_active(void)const;
};

class IMPORT INI_Reader
{
	char szBuf[1024];

public:
	INI_Reader(class INI_Reader const &);
	INI_Reader(void);
	~INI_Reader(void);
	class INI_Reader & operator=(class INI_Reader const &);
	void close(void);
	float get_value_float(unsigned int);
	int get_value_int(unsigned int);
	char const * get_value_ptr(void);
	char const * get_value_string(unsigned int);
	char const * get_value_string(void);
	unsigned short const * get_value_wstring(void);
	bool is_header(char const *);
	bool is_number(char const *)const ;
	bool is_value(char const *);
	bool is_value_empty(unsigned int);
	bool open(char const *,bool);
	bool read_header(void);
	bool read_value(void);
	void reset(void);
};

struct IMPORT IObject
{
	enum ThrustEquipType;
};

struct IMPORT IObjInspect
{
	struct CargoEnumerator;
	struct SubtargetEnumerator;
};

struct IMPORT IObjInspectImpl
{
public:
	virtual class Vector const & get_position(void)const ;
	virtual class Vector  get_velocity(void)const ;
	virtual class Vector  get_angular_velocity(void)const ;
	virtual class Matrix const & get_orientation(void)const ;
	virtual class Transform const & get_transform(void)const ;
	virtual class Vector  get_center_of_mass(void)const ;
	virtual int get_sub_obj_center_of_mass(unsigned short,class Vector &)const ;
	virtual long get_index(void)const ;
	virtual unsigned int const  get_id(void)const ;
	virtual int get_good_id(unsigned int &)const ;
	virtual int get_archetype_extents(class Vector &,class Vector &)const ;
	virtual int get_physical_radius(float &,class Vector &)const ;
	virtual float get_mass(void)const ;
	virtual bool is_targetable(void)const ;
	virtual bool is_dying(void)const ;
	virtual int get_status(float &,float &)const ;
	virtual int get_status(float &)const ;
	virtual int get_shield_status(float &,float &,bool &)const ;
	virtual int get_shield_status(float &,bool &)const ;
	virtual int get_throttle(float &)const ;
	virtual int get_axis_throttle(class Vector &)const ;
	virtual int get_nudge_vec(class Vector &)const ;
	virtual int get_strafe_dir(enum StrafeDir &)const ;
	virtual int is_cruise_active(bool &)const ; // why in different order ?! msvc i hate you! both is_cruise_active dont work properly for players(always return false when engine kill was used during cruise) 
	virtual int is_cruise_active(bool &,bool &)const ;
	virtual int are_thrusters_active(bool &)const ;
	virtual int get_attitude_towards(float &,struct IObjInspect const *)const ;
	virtual int get_attitude_towards_symmetrical(float &,struct IObjInspect const *,float &)const ;
	virtual int get_reputation(float &,unsigned int const &)const ;
	virtual int get_target(struct IObjRW * &)const ;
	virtual int get_subtarget(unsigned short &)const ;
	virtual int get_subtarget_center_of_mass(class Vector &)const ;
	virtual int get_rank(unsigned int &)const ;
	virtual int get_affiliation(unsigned int &)const ;
	virtual int get_type(unsigned int &)const ;
	virtual int get_base(unsigned int &)const ;
	virtual int get_dock_target(unsigned int &)const ;
	virtual int get_power(float &)const ;
	virtual int get_zone_props(unsigned long &)const ;
	virtual float get_scanner_interference(void)const ;
	virtual int get_hold_left(float &)const ;
	virtual int enumerate_cargo(struct IObjInspect::CargoEnumerator *)const ;
	virtual int get_data(void const * &)const ;
	virtual int get_formation_offset(class Vector &)const ;
	virtual int get_formation_leader(struct IObjRW * &)const ;
	virtual int get_follow_offset(class Vector &)const ;
	virtual int get_follow_leader(struct IObjRW * &)const ;
	virtual bool is_player(void)const ;
	virtual int get_hardpoint(char const *,class Vector *,class Matrix *)const ;
	virtual bool has_dock_hardpoints(void)const ;
	virtual int get_dock_hardpoints(int,enum TERMINAL_TYPE *,class Transform *,class Transform *,class Transform *,float *)const ;
	virtual float get_time_to_accelerate(float,float,float,enum IObject::ThrustEquipType)const ;
	virtual float get_distance_travelled(float,float,float,enum IObject::ThrustEquipType)const ;
	virtual float get_projected_throttle(float,enum IObject::ThrustEquipType)const ;
	virtual float get_speed(float,enum IObject::ThrustEquipType)const ;
	virtual float get_initial_speed_to_coast_distance(float,bool)const ;
	virtual float get_time_to_accelerate_angularly(float,float,float)const ;
	virtual float get_time_to_accelerate_angularly(float,float,float,float)const ;
	virtual float get_angular_distance_travelled(float,float,float)const ;
	virtual float get_angular_distance_travelled(float,float,float,float)const ;
	virtual float get_angular_speed_XY(float,float)const ;
	virtual float get_angular_speed_Z(float)const ;
	virtual float get_projected_axis_throttle_XY(float)const ;
	virtual float get_projected_axis_throttle_Z(float)const ;
	virtual float get_max_bank_angle(void)const ;
	virtual int get_scanlist(struct ScanList const * &,unsigned int,bool)const ;
	virtual int get_tgt_lead_fire_pos(unsigned short const &,class Vector &)const ;
	virtual int is_pointing_at(bool &,unsigned short const &,float)const ;
	virtual int can_point_at(bool &,unsigned short const &,class Vector const &,float)const ;
	virtual int find_equipment(unsigned short * const,unsigned int,unsigned int)const ;
	virtual int get_equipment_status(struct EquipStatus &,unsigned short const &)const ;
	virtual int get_equipment_val(struct EquipmentVal &,unsigned short const &,enum EquipmentValType,float)const ;
	virtual int scan_cargo(struct IObjRW *,struct EquipDescVector &)const ;
	virtual int enumerate_subtargets(struct IObjInspect::SubtargetEnumerator *)const ;
	virtual int get_lane_direction(class Transform const &,bool *)const ;
	virtual int get_ring_side(class Transform const &,bool *)const ;
	virtual int traverse_rings(unsigned int &,bool)const ;
	virtual int is_using_tradelane(bool *)const ;
	virtual int get_lane_start(struct IObjInspect const *,struct IObjInspect const * &,class Vector &,class Vector &)const ;
	virtual bool generate_follow_offset(struct IObjInspect const *,class Transform &)const ;
	virtual int get_atmosphere_range(float &)const ;
	virtual int get_toughness(void)const ;
	virtual int get_behavior_id(void)const ;
	virtual int get_formation_followers(struct IObjRW * * const,unsigned int)const ;
	virtual struct CObject const * cobject(void)const ;


/*	IObjInspectImpl(struct IObjInspectImpl const &);
	IObjInspectImpl(void);
	virtual ~IObjInspectImpl(void);
	struct IObjInspectImpl & operator=(struct IObjInspectImpl const &);

private:
//	int find_equipment(class CEquip const * &,unsigned short const &)const ; */
	char szBuf[1024];
};

#endif
