using System;
using System.Net;
using System.Net.Sockets;
using System.Threading;

namespace Tlr.Freelancer
{
	/// <summary>
	/// Contains information about a Freelancer Server's state.
	/// A server is essentially a service point - an IP address or
	/// host name and a port on which flserver is listening.
	/// State at a particular point in time is defined by response time,
	/// current user load, sr
	/// </summary>
	public class Network
	{
		byte[] pingBuffer = new byte[0x15]
{ 0x0, 0x2, 0xf1, 0x26, 0x1, 0x26, 0xf0,
	0x90, 0xa6, 0xf0, 0x26, 0x57, 0x4e, 0xac,
	0xa0, 0xec, 0xf8, 0x68, 0xe4, 0x8d, 0x21
};




		
		/// <summary>
		/// Freelancer "name" description
		/// </summary>
		public string Name {get{return MyName;}}
		private string MyName;

		/// <summary>
		/// Returns non-Unicode extended data from the server response.
		/// </summary>
		public string ExtendedData {get{return MyExtendedData;}}
		private string MyExtendedData;

		/// <summary>
		/// Length of server response. For debugging use.
		/// </summary>
		public int LastReceiveBufferLength{get{return MyLastReceiveBufferLength;}}
		private int MyLastReceiveBufferLength;

		/// <summary>
		/// Actual host name or address used in the lookup.
		/// </summary>
		public string HostAddress {get{return MyHostAddress;}}
		private string MyHostAddress;

		/// <summary>
		/// Response time for the connection in milliseconds
		/// </summary>
		public int ResponseTime{get{return MyResponseTime;}}
		private int MyResponseTime;

		/// <summary>
		/// Maximum number of players allowed on the server
		/// </summary>
		public int PlayerMaximum{get{return MyPlayerMaximum;}}
		private int MyPlayerMaximum;

		/// <summary>
		/// Current number of players on the server.
		/// </summary>
		public int PlayerCount{get{return MyPlayerCount;}}
		private int MyPlayerCount;
		/// <summary>
		/// TCP port to use for connection; default is 2302.
		/// </summary>
		public int Port
		{
			get{return MyPort;}
			set{MyPort = value;}
		} private int MyPort = 2302;

		/// <summary>
		/// Time in milliseconds to wait. Default is 2000.
		/// </summary>
		public int Timeout
		{
			get{return MyTimeout;}
			set{MyTimeout = value;}
		} private int MyTimeout = 5000;

		/// <summary>
		/// Runs a query against a Freelancer server.
		/// Returns true if it succeeds, false if it fails.
		/// </summary>
		/// <param name="serverAddress">IP address or searchable name of the FL server.</param>
		public bool QueryServer(string serverAddress)
		{
			try
			{
				int blockTime = 25; // milliseconds to block on each sleep cycle
			IPHostEntry hostEntry = Dns.Resolve(serverAddress);
			IPEndPoint serverPoint = new IPEndPoint(hostEntry.AddressList[0], MyPort);
				Socket pingSocket = 
					new Socket(serverPoint.Address.AddressFamily, SocketType.Dgram, ProtocolType.Udp);
				DateTime timeInitial = DateTime.Now;
				DateTime timeFinal;
				pingSocket.SendTo
					(pingBuffer, 0, pingBuffer.Length, SocketFlags.None, serverPoint);
				IPEndPoint localPort = new IPEndPoint(IPAddress.Any,0);
				EndPoint storedEndPoint = localPort;
				byte[] dataBuffer;
				for (int i = 0; (pingSocket.Available < 1) && (i < (int)(MyTimeout/blockTime)); i++)
				{
					Thread.Sleep(blockTime);
				}
				timeFinal = DateTime.Now;
				dataBuffer = new byte[pingSocket.Available];
				System.TimeSpan dt = (System.TimeSpan)(timeFinal.Subtract(timeInitial));
				MyResponseTime = dt.Milliseconds;
				MyLastReceiveBufferLength = pingSocket.ReceiveFrom
					(dataBuffer, 0, pingSocket.Available,
					SocketFlags.None, ref storedEndPoint);
				int descriptionStart = 0x5c;
				int descriptionBufferEnd = 0;
				int descriptionLength = (int)dataBuffer[4] - descriptionStart;
				descriptionBufferEnd = (descriptionLength + descriptionStart) + 2;
				byte[] descriptionBuffer = new byte[descriptionLength];
				int currentChar = 0;
				for (int i = descriptionStart; i < descriptionBufferEnd; i++)
				{
					if ((int)dataBuffer[i] > 0)
					{
						descriptionBuffer[currentChar] = dataBuffer[i];
						currentChar++;
					}
				}
				byte[] extendedBuffer;
				extendedBuffer = new byte[MyLastReceiveBufferLength - descriptionBufferEnd];
				currentChar = 0;
				for (int i = descriptionBufferEnd; i < extendedBuffer.Length; i++)
				{
					if ((int)dataBuffer[i] > 0)
					{
						extendedBuffer[currentChar] = dataBuffer[i];
						currentChar++;
						byte[] b = new byte[1]; b[0] = dataBuffer[i];
					}

				}

				MyHostAddress = serverAddress;
				MyName = System.Text.Encoding.ASCII.GetString(descriptionBuffer);
				MyExtendedData = System.Text.Encoding.ASCII.GetString(extendedBuffer);
				//int text = System.Text.Encoding.Unicode.GetString(extendedBuffer);
				MyPlayerCount = (int)(dataBuffer[0x18]) - 1;
				MyPlayerMaximum = (int)(dataBuffer[20]) - 1;

				return true;
			}
			catch
			{
				return false;

			}
		}





			
    }

	}

