Option Explicit

Dim fso: Set fso = createobject("Scripting.FileSystemObject")
Dim flPath: flPath = FreelancerExePath()
Dim flDir: flDir = fso.GetParentFolderName(flPath)

' We're going to get the "short name" of the file in an effort to
' conserve space for extra server names on the commandline.
Dim flName: flName = fso.GetFile(flPath).ShortName

Dim cmdLine: cmdLine = flName & " -s200.74.164.81:2302 -s202.36.205.20:2302 -s24.76.252.252:2302 -s207.236.55.56:2302 -s209.204.184.162:2302 -s210.48.102.190:2302 -s210.48.104.130:2302 -s210.51.165.50:2302 -s211.30.236.115:2375 -s212.127.213.149:2302 -s212.159.115.18:2375 -s212.159.75.238:2302 -s212.176.84.38:2302 -s212.227.21.64:2302 -s212.238.217.188:2302 -s212.74.185.89:2302 -s212.87.0.39:2302 -s213.148.132.20:2302 -s213.202.211.64:2302 -s213.27.19.92:2375 -s213.84.38.42:2302 -s216.196.208.222:2302 -s216.231.48.121:2302 -s217.13.33.199:2302 -s217.146.85.15:2302 -s217.148.6.134:2302 -s217.157.238.216:2302 -s217.160.177.206:2302 -s217.207.194.210:2302 -s217.68.168.85:2375 -s220.237.47.69:2302 -s24.10.198.67:2302 -s24.119.76.228:13256 -s24.141.105.181:2302 -s24.148.55.83:2302 -s24.152.136.141:2302 -s24.17.167.143:15560 -s24.196.25.91:2302 -s24.27.125.27:2302 -s38.113.32.156:2302 -s38.113.32.69:2302 -s4.11.15.8:21704 -s4.12.31.48:2302 -s4.14.105.111:2302 -s61.98.97.135:2302 -s62.210.249.176:2302 -s62.75.174.160:2302 -s62.75.222.199:2375 -s64.185.117.188:2302 -s66.111.62.10:2302 -s66.15.58.192:2362 -s66.159.226.113:2302 -s66.189.176.255:2302 -s66.214.230.106:13 -s66.26.255.24:2304 -s66.26.255.24:2308 -s66.31.3.239:21961 -s66.38.146.110:2375 -s66.39.168.36:2302 -s66.41.236.41:2302"

Dim WshShell: Set WshShell = CreateObject("WScript.Shell")
Dim startDir: startDir = WshShell.CurrentDirectory
WshShell.CurrentDirectory = flDir
WshShell.Run cmdLine
WshShell.CurrentDirectory = startDir

Function FreelancerExePath()
	'Tries to find Freelancer by using fl-path.txt in the same folder.
	' If not found, then uses the registry path.
	Dim fso: Set fso = createobject("Scripting.FileSystemObject")
	Dim flPath, foundApp: foundApp = False
	If fso.FileExists("fl-path.txt") Then
		flPath = NewTextReader("fl-path.txt").ReadLine
		If fso.FileExists(flPath) Then foundApp = True
	End If
	If Not foundApp Then
		Dim regPath
		regPath = "HKLM\SOFTWARE\Microsoft\Microsoft Games\Freelancer\1.0\AppPath"
		Dim WshShell: Set WshShell = CreateObject("WScript.Shell")
		flPath = fso.BuildPath(WshShell.RegRead(regPath), "exe\freelancer.exe")
	End If
	FreelancerExePath = flPath
End Function




Function NewTextReader(FilePath)
	Dim fso, file
	Set fso = createobject("Scripting.FileSystemObject")
	If fso.FileExists(FilePath) Then
		Set file = fso.OpenTextFile(FilePath, 1, False, -2)
		If file.AtEndOfStream = False Then
			Set NewTextReader = file
			Exit Function
		End If
	End If
	Set NewTextReader = Nothing
End Function

Function ReadLines(FilePath)
	' Given the path to a file, will return array of nonempty lines
	Dim fso, file, data(), tmp
	redim data(-1)
	Set fso = createobject("Scripting.FileSystemObject")
	If fso.FileExists(FilePath) Then
		Set file = fso.OpenTextFile(FilePath, 1, False, -2)
		Do while not file.AtEndOfStream
			tmp = trim(file.ReadLine)
			if len(tmp) > 0 then
				redim preserve data(ubound(data) + 1)
				data(ubound(data)) = tmp
			end if
		Loop
		file.Close
	End If
	ReadLines = data
End Function