Option Explicit

Const FlRegPath = _
	"HKLM\SOFTWARE\Microsoft\Microsoft Games\Freelancer\1.0\AppPath"
Dim WshShell: Set WshShell = CreateObject("WScript.Shell")
Dim fso: Set fso = CreateObject("Scripting.FileSystemObject")

Dim changeCount: changeCount = 0
Dim MissionPath
MissionPath = WshShell.RegRead(FlRegPath) & "\DATA\MISSIONS"
' This starts recursive folder enumeration.
' The ProcessFolder routine will iterate all nested folders, and pass
' filenames to ProcessFile.
' ProcessFile contains logic for INI selection and modification.
ProcessFolder fso.GetFolder(MissionPath)
WScript.Echo "Made", changeCount, "edits turning cutscenes OFF."

Sub ProcessFolder(ByRef folder) ' It has to be ByRef; making it obvious...
	'We do a breadth-first search for files
	Dim file, files, subfolder: Set files = folder.Files
	Dim endName
	For Each file in files
		endName = LCase(Right(file.Name, 8))
		If endName = "nrml.ini" or endName = "ffer.ini" Then ProcessFile(file)
	Next
	For Each subfolder in folder.SubFolders
		ProcessFolder subfolder
	Next
End Sub



Sub ProcessFile(ByRef file) ' It has to be ByRef; making it obvious...
	' done if not an ini file.
	Dim iniPath, src, target, data
	iniPath = file.Path
	file.move iniPath & ".bak"
	Set src = file.OpenAsTextStream
	Set target = fso.OpenTextFile(iniPath, 2, True)
	'WScript.StdOut.WriteLine iniPath
	Do While Not src.AtEndOfStream
		data = src.ReadLine
		Select Case LCase(Left(data, 5))
			Case "actio", "accep", "decli", "offer"
				changeCount =  changeCount + 1
				target.Write ";"
		End Select
		target.WriteLine data
	Loop
	src.Close
	file.Delete True
End Sub