<?php
// wcf imports
require_once(WCF_DIR.'lib/data/shoutbox/ShoutboxEntryList.class.php');
require_once(WCF_DIR.'lib/page/SortablePage.class.php');
require_once(WCF_DIR.'lib/page/util/menu/PageMenu.class.php');

/**
 * Shows a list of all shoutbox entries.
 *
 * @author	Sebastian ttl
 * @copyright	2009 Sebastian ttl
 * @license	GNU Lesser General Public License <http://opensource.org/licenses/lgpl-license.php>
 * @package	com.mysteryforce.wcf.shoutbox
 * @subpackage	lib.acp.page
 * @category 	Shoutbox
 */
class ShoutboxEntryArchivesPage extends SortablePage {
	// system
	public $itemsPerPage = 20;
	public $defaultSortField = 'time';
	public $templateName = 'shoutboxEntryArchives';
	public $neededPermissions = 'user.shoutbox.canEnterEntryArchives';
	
	// data
	public $entryList = null;
	
	/**
	 * @see Page::readParameters()
	 */	
	public function readParameters() {
		parent::readParameters();
		
		// get entry list
		$this->entryList = new ShoutboxEntryList;
	}
	
	/**
	 * @see Page::readData()
	 */	
	public function readData() {
		parent::readData();
		
		// get entries
		$this->entryList->sqlLimit = $this->itemsPerPage;
		$this->entryList->sqlOffset = ($this->pageNo - 1) * $this->itemsPerPage;	
		$this->entryList->sqlOrderBy = $this->sortField." ".$this->sortOrder;
		$this->entryList->readObjects();
	}
	
	/**
	 * @see MultipleLinkPage::countItems()
	 */	
	public function countItems() {
		parent::countItems();

		return $this->entryList->countObjects();
	}
	
	/**
	 * @see Page::show()
	 */
	public function show() {
		// set active menu item
		PageMenu::setActiveMenuItem('wcf.footer.menu.shoutbox.entry.archives');

		// show page
		parent::show();
	}
	
	/**
	* @see Page::assignVariables()
	 */
	public function assignVariables() {	
		parent::assignVariables();
				
		WCF::getTPL()->assign(array(
			'entries' => $this->entryList->getObjects()
		));
	}
	
	/**
	 * @see SortablePage::validateSortField()
	 */
	public function validateSortField() {
		parent::validateSortField();
		
		switch ($this->sortField) {
			case 'entryID':
			case 'username':
			case 'message':
			case 'time': break;
			default: $this->sortField = $this->defaultSortField;
		}
	}
}
?>