<?php
// wcf imports
require_once(WCF_DIR.'lib/data/message/bbcode/MessageParser.class.php');
require_once(WCF_DIR.'lib/data/shoutbox/ShoutboxEntry.class.php');

/**
 * Represents a viewable shoutbox entry.
 * 
 * @author	Sebastian ttl
 * @copyright	2009 Sebastian ttl
 * @license	GNU Lesser General Public License <http://opensource.org/licenses/lgpl-license.php>
 * @package	com.mysteryforce.wcf.shoutbox
 * @subpackage	lib.data.shoutbox
 * @category 	Shoutbox
 */
class ViewableShoutboxEntry extends ShoutboxEntry {	
	/**
	 * Returns the formatted message of this entry.
	 *
	 * @return 	string		the formatted message of this entry
	 */	
	public function getFormattedMessage() {	
		$parser = MessageParser::getInstance();
		$parser->setOutputType('text/html');
		return $parser->parse($this->message, 1, 0, 0, false);		
	}
}
?>