<?php
// wcf imports
require_once(WCF_DIR.'lib/action/AbstractAction.class.php');
require_once(WCF_DIR.'lib/data/shoutbox/ShoutboxEntryEditor.class.php');

/**
 * Deletes a shoutbox entry.
 *
 * @author	Sebastian ttl
 * @copyright	2009 Sebastian ttl
 * @license	GNU Lesser General Public License <http://opensource.org/licenses/lgpl-license.php>
 * @package	com.mysteryforce.wcf.shoutbox
 * @subpackage	action
 * @category 	Shoutbox
 */
class ShoutboxEntryDeleteAction extends AbstractAction {
	/**
	 * entry id
	 *
	 * @var	integer
	 */
	public $entryID = 0;

	/**
	 * entry editor object
	 *
	 * @var	ShoutboxEntryEditor
	 */
	public $entry = null;
	
	/**
	 * @see Action::readParameters()
	 */
	public function readParameters() {
		parent::readParameters();
		
		// get entry id
		if (isset($_GET['entryID'])) $this->entryID = intval($_GET['entryID']);
		
		// get entry
		$this->entry = new ShoutboxEntryEditor($this->entryID);
		if (!$this->entry->entryID) {
			throw new IllegalLinkException();
		}
	}
	
	/**
	 * @see Action::execute()
	 */
	public function execute() {
		parent::execute();
		
		// delete entry
		$this->entry->delete();
		$this->executed();
		
		// forward to shoutbox entry archives
		HeaderUtil::redirect('index.php?page=ShoutboxEntryArchives'.SID_ARG_2ND_NOT_ENCODED);
		exit;
	}
}
?>