<?php
/**
 * @author	Sebastian ttl
 * @copyright	2009 Sebastian ttl
 * @license	GNU Lesser General Public License <http://opensource.org/licenses/lgpl-license.php>
 */
$packageID = $this->installation->getPackageID();
$packageDir = $this->installation->getPackage()->getDir();

// user and mod options
$sql = "UPDATE 	wcf".WCF_N."_group_option_value
	SET	optionValue = 1
	WHERE	groupID IN (4,5,6)
		AND optionID IN (
			SELECT	optionID
			FROM	wcf".WCF_N."_group_option
			WHERE	optionName LIKE 'mod.shoutbox.%'
				OR optionName LIKE 'user.shoutbox.%'
				AND packageID IN (
					SELECT	dependency
					FROM	wcf".WCF_N."_package_dependency
					WHERE	packageID = ".$packageID."
				)
		)
		AND optionValue = '0'";
WCF::getDB()->sendQuery($sql);

// refresh style files
require_once(WCF_DIR.'lib/data/style/StyleEditor.class.php');
$sql = "SELECT 	*
	FROM 	wcf".WCF_N."_style";
$result = WCF::getDB()->sendQuery($sql);
while ($row = WCF::getDB()->fetchArray($result)) {
	$style = new StyleEditor(null, $row);
	$style->writeStyleFile();
}

/**
 * Deletes files, templates and acp templates.
 * 
 * @author	Sebastian ttl
 * @copyright	2009 Sebastian ttl
 * @license	GNU Lesser General Public License <http://opensource.org/licenses/lgpl-license.php>
 * @category 	FileDeleteUtil
 */
class FileDeleteUtil {
	public $deleteEmptyTargetDir = true;
	public $deleteEmptySubDirs = true;
	public $files = array(), $templates = array(), $acpTemplates = array();
	public $packageID = 0;
	public $packageDir = '';
	public $safeMode = null;
	protected $pluginFiles = null, $pluginTemplates = null, $pluginACPTemplates = null;

	/**
	 * Starts the delete progress.
	 */
	public function startProgress() {
		// require files
		require_once(WCF_DIR.'lib/system/setup/FileUninstaller.class.php');
		require_once(WCF_DIR.'lib/system/setup/FTPUninstaller.class.php');
		// delete file data
		$this->deleteFileData();
		// delete template data
		$this->deleteTemplateData();
		// delete acp template data
		$this->deleteACPTemplateData();
	}
	
	/**
	 * Deletes the files.
	 */
	protected function deleteFileData() {
		if (!count($this->files)) return;
		if ($this->pluginFiles === null) {
			$this->pluginFiles = $this->getPluginFiles();
		}
		foreach ($this->files as $file) {
			if (in_array($file, $this->pluginFiles)) {							
				$deletableFiles[] = $file;
				$sql = "DELETE	FROM wcf".WCF_N."_package_installation_file_log
					WHERE	filename = '".$file."'
						AND packageID = ".$this->packageID;
				WCF::getDB()->registerShutdownUpdate($sql);
			}
			else {
				throw new SystemException("This plugin is not allowed to remove the file '".$file."'!");
			}
		}
		$this->deleteFiles($deletableFiles, $this->deleteEmptyTargetDir, $this->deleteEmptySubDirs);
	}
	
	/**
	 * Deletes the templates.
	 */
	protected function deleteTemplateData() {
		if (!count($this->templates)) return;
		if ($this->pluginTemplates === null) {
			$this->pluginTemplates = $this->getPluginTemplates();
		}
		foreach ($this->templates as $templateID => $template) {
			$templateName = StringUtil::replace('.tpl', '', $template);
			if (in_array($templateName, $this->pluginTemplates)) {
				// delete template data
				$deletableFiles[] = 'templates/'.$template;
				$sql = "DELETE	FROM wcf".WCF_N."_template
					WHERE	templateName = '".$templateName."'
						AND packageID = ".$this->packageID;
				WCF::getDB()->registerShutdownUpdate($sql);
							
				// delete template patch data
				$sql = "DELETE	FROM wcf".WCF_N."_template_patch
					WHERE	templateID = ".$templateID."
						AND packageID = ".$this->packageID;
				WCF::getDB()->registerShutdownUpdate($sql);
			}
			else {
				throw new SystemException("This plugin is not allowed to remove the template '".$template."'!");
			}
		}
		$this->deleteFiles($deletableFiles, false, false);
	}
	
	/**
	 * Deletes the acp templates.
	 */
	protected function deleteACPTemplateData() {
		if (!count($this->acpTemplates)) return;
		if ($this->pluginACPTemplates === null) {
			$this->pluginACPTemplates = $this->getPluginACPTemplates();
		}
		foreach ($this->acpTemplates as $templateID => $template) {
			$templateName = StringUtil::replace('.tpl', '', $template);
			if (in_array($templateName, $this->pluginACPTemplates)) {
				// delete template data
				$deletableFiles[] = 'acp/templates/'.$template;
				$sql = "DELETE	FROM wcf".WCF_N."_acp_template
					WHERE	templateName = '".$templateName."'
						AND packageID = ".$this->packageID;
				WCF::getDB()->registerShutdownUpdate($sql);
							
				// delete template patch data
				$sql = "DELETE	FROM wcf".WCF_N."_acp_template_patch
					WHERE	templateID = ".$templateID."
						AND packageID = ".$this->packageID;
				WCF::getDB()->registerShutdownUpdate($sql);
			}
			else {
				throw new SystemException("This plugin is not allowed to remove the acp template '".$template."'!");
			}
		}
		$this->deleteFiles($deletableFiles, false, false);
	}
	
	/**
	 * Deletes the given files.
	 *
	 * @param	array		$files
	 * @param	boolean		$deleteEmptyTargetDir
	 * @param	boolean		$deleteEmptySubDirs
	 */
	protected function deleteFiles($files, $deleteEmptyTargetDir, $deleteEmptySubDirs) {
		if (count($files)) {
			$packageDir = FileUtil::addTrailingSlash(FileUtil::unifyDirSeperator(realpath(WCF_DIR.$this->packageDir)));
			if ($ftp = $this->safeMode) {
				require_once(WCF_DIR.'lib/system/setup/FTPUninstaller.class.php');
				new FTPUninstaller($packageDir, $files, $ftp, $deleteEmptyTargetDir, $deleteEmptySubDirs);
			}
			else {
				require_once(WCF_DIR.'lib/system/setup/FileUninstaller.class.php');
				new FileUninstaller($packageDir, $files, $deleteEmptyTargetDir, $deleteEmptySubDirs);
			}
		}
	}
	
	/**
	 * Makes a list of files for this plugin.
	 *
	 * @return	array
	 */
	protected function getPluginFiles() {
		$pluginFiles = array();
		$sql = "SELECT	filename
			FROM	wcf".WCF_N."_package_installation_file_log
			WHERE	packageID = ".$this->packageID;
		$result = WCF::getDB()->sendQuery($sql);
		while ($row = WCF::getDB()->fetchArray()) {
			$pluginFiles[] = $row['filename'];
		}
		return $pluginFiles;
	}

	/**
	 * Makes a list of templates for this plugin.
	 *
	 * @return	array
	 */
	protected function getPluginTemplates() {
		$pluginTemplates = array();
		$sql = "SELECT	templateID,
				templateName
			FROM	wcf".WCF_N."_template
			WHERE	packageID = ".$this->packageID;
		$result = WCF::getDB()->sendQuery($sql);
		while ($row = WCF::getDB()->fetchArray()) {
			$pluginTemplates[$row['templateID']] = $row['templateName'];
		}
		return $pluginTemplates;
	}

	/**
	 * Makes a list of acp templates for this plugin.
	 *
	 * @return	array
	 */
	protected function getPluginACPTemplates() {
		$pluginACPTemplates = array();
		$sql = "SELECT	templateID,
				templateName
			FROM	wcf".WCF_N."_acp_template
			WHERE	packageID = ".$this->packageID;
		$result = WCF::getDB()->sendQuery($sql);
		while ($row = WCF::getDB()->fetchArray()) {
			$pluginACPTemplates[$row['templateID']] = $row['templateName'];
		}
		return $pluginACPTemplates;
	}
}
$fileDelete = new FileDeleteUtil;
$fileDelete->packageID = $packageID;
$fileDelete->packageDir = $packageDir;
$fileDelete->safeMode = $this->installation->checkSafeMode();
$fileDelete->files = array(
	'lib/acp/action/ShoutboxEntryDeleteAction.class.php',
	'lib/acp/page/ShoutboxEntryListPage.class.php'
);
$fileDelete->acpTemplates = array(
	'shoutboxEntryList.tpl'
);
$fileDelete->startProgress();
?>