<?php
// wcf imports
require_once(WCF_DIR.'lib/data/message/Message.class.php');

/**
 * Represents a shoutbox entry.
 * 
 * @author	Sebastian ttl
 * @copyright	2009 Sebastian ttl
 * @license	GNU Lesser General Public License <http://opensource.org/licenses/lgpl-license.php>
 * @package	com.mysteryforce.wcf.shoutbox
 * @subpackage	lib.data.shoutbox
 * @category 	Shoutbox
 */
class ShoutboxEntry extends Message {	
	/**
	 * Creates a new ShoutboxEntry object.
	 *
	 * If id is set, the function reads the entry data from database.
	 * Otherwise it uses the given resultset.
	 *
	 * @param 	integer 	$entryID	id of an entry
	 * @param 	array 		$row		resultset with entry data form database
	 */
	public function __construct($entryID, $row = null) {		
		if ($entryID !== null) {			
			$sql = "SELECT	* 
				FROM	wcf".WCF_N."_shoutbox_entry
				WHERE	entryID = ".$entryID;
			$row = WCF::getDB()->getFirstRow($sql);			
		}
		parent::__construct($row);
		$this->messageID = $row['entryID'];
	}
	
	/**
	 * Checks if this entry is owned by the active user.
	 *
	 * @return	boolean
	 */
	public function isOwnEntry() {
		return WCF::getUser()->userID == $this->userID;
	}
	
	/**
	 * Checks if the active user can delete this entry.
	 *
	 * @return	boolean
	 */
	public function canDeleteEntry() {
		return (WCF::getUser()->getPermission('user.shoutbox.canDeleteOwnEntry') && $this->isOwnEntry()
			|| WCF::getUser()->getPermission('mod.shoutbox.canDeleteEntry'))
			&& WCF::getUser()->userID;
	}
}
?>