/**
 * @author	Sebastian ttl
 * @copyright	2009 Sebastian ttl
 * @license	GNU Lesser General Public License <http://opensource.org/licenses/lgpl-license.php>
 */
var Shoutbox = Class.create({
	/**
	 * Inits Shoutbox.
	 */
	initialize: function(interval) {
		if (interval != 0) {
			new Ajax.PeriodicalUpdater('shoutboxContent', 'index.php?page=ShoutboxAction&action=getEntries'+'&t='+SECURITY_TOKEN+SID_ARG_2ND, {
				method: 'get',
				frequency: interval
			});
		}
		else {
			this.updateEntries();
		}
	},
	
	/**
	 * Adds a new entry.
	 */
	addEntry: function() {
		var message = '';
		var username = '';

		if ($('shoutboxMessage')) {
			message = $('shoutboxMessage').value;
			$('shoutboxMessage').value = '';
		}
		if ($('shoutboxUsername')) {
			username = $('shoutboxUsername').value;
		}
		
		new Ajax.Request('index.php?page=ShoutboxAction&action=add'+'&t='+SECURITY_TOKEN+SID_ARG_2ND, {
			method: 'get',
			parameters: {
				message: message,
				username: username
			},
			onSuccess: this.updateEntries
		});
	},

	/**
	 * Deletes an entry.
	 */	
	deleteEntry: function(id) {
		new Ajax.Request('index.php?page=ShoutboxAction&action=delete'+'&t='+SECURITY_TOKEN+SID_ARG_2ND, {
			method: 'get',
			parameters: {
				entryID: id
			},
			onSuccess: this.updateEntries
		});		
	},
	
	/**
	 * Updates the entries.
	 * @todo	It's a bit slow to submit the full html code - in the future I will use xml.
	 */
	updateEntries: function() {
		new Ajax.Updater('shoutboxContent', 'index.php?page=ShoutboxAction&action=getEntries'+'&t='+SECURITY_TOKEN+SID_ARG_2ND, {
			method: 'get'
		});
	}
});