{include file="documentHeader"}
<head>
	<title>{lang}wcf.shoutbox.entry.archives{/lang} - {lang}{PAGE_TITLE}{/lang}</title>

	{include file='headInclude' sandbox=false}
	<script type="text/javascript" src="{@RELATIVE_WCF_DIR}js/MultiPagesLinks.class.js"></script>
</head>
<body{if $templateName|isset} id="tpl{$templateName|ucfirst}"{/if}>
{include file='header' sandbox=false}

<div id="main">

	<ul class="breadCrumbs">
		<li><a href="index.php?page=Index{@SID_ARG_2ND}"><img src="icon/indexS.png" alt="" /> <span>{lang}{PAGE_TITLE}{/lang}</span></a> &raquo;</li>
	</ul>
	
	<div class="mainHeadline">
		<img src="{icon}shoutboxL.png{/icon}" alt="" />
		<div class="headlineContainer">
			<h2><a href="index.php?page=ShoutboxEntryArchives{@SID_ARG_2ND}">{lang}wcf.shoutbox.entry.archives{/lang}</a></h2>
		</div>
	</div>
	
	{if $userMessages|isset}{@$userMessages}{/if}

	<div class="contentHeader">
		{pages print=true assign=pagesLinks link="index.php?page=ShoutboxEntryArchives&pageNo=%d&sortField=$sortField&sortOrder=$sortOrder&packageID="|concat:PACKAGE_ID:SID_ARG_2ND_NOT_ENCODED}
	</div>

	{if $entries|count}
		<div class="border titleBarPanel">
			<div class="containerHead"><h3>{lang}wcf.shoutbox.entry.archives.count{/lang}</h3></div>
		</div>
		<div class="border borderMarginRemove">
			<table class="tableList">
				<thead>
					<tr class="tableHead">
						<th class="columnEntryID{if $sortField == 'entryID'} active{/if}" colspan="2"><div><a href="index.php?page=ShoutboxEntryArchives&amp;pageNo={@$pageNo}&amp;sortField=entryID&amp;sortOrder={if $sortField == 'entryID' && $sortOrder == 'ASC'}DESC{else}ASC{/if}{@SID_ARG_2ND}">{lang}wcf.shoutbox.entry.entryID{/lang}{if $sortField == 'entryID'} <img src="{@RELATIVE_WCF_DIR}icon/sort{@$sortOrder}S.png" alt="" />{/if}</a></div></th>
						<th class="columnUsername{if $sortField == 'username'} active{/if}"><div><a href="index.php?page=ShoutboxEntryArchives&amp;pageNo={@$pageNo}&amp;sortField=username&amp;sortOrder={if $sortField == 'username' && $sortOrder == 'ASC'}DESC{else}ASC{/if}{@SID_ARG_2ND}">{lang}wcf.shoutbox.entry.username{/lang}{if $sortField == 'username'} <img src="{@RELATIVE_WCF_DIR}icon/sort{@$sortOrder}S.png" alt="" />{/if}</a></div></th>
						<th class="columnMessage{if $sortField == 'message'} active{/if}"><div><a href="index.php?page=ShoutboxEntryArchives&amp;pageNo={@$pageNo}&amp;sortField=message&amp;sortOrder={if $sortField == 'message' && $sortOrder == 'ASC'}DESC{else}ASC{/if}{@SID_ARG_2ND}">{lang}wcf.shoutbox.entry.message{/lang}{if $sortField == 'message'} <img src="{@RELATIVE_WCF_DIR}icon/sort{@$sortOrder}S.png" alt="" />{/if}</a></div></th>
						<th class="columnTime{if $sortField == 'time'} active{/if}"><div><a href="index.php?page=ShoutboxEntryArchives&amp;pageNo={@$pageNo}&amp;sortField=time&amp;sortOrder={if $sortField == 'time' && $sortOrder == 'ASC'}DESC{else}ASC{/if}{@SID_ARG_2ND}">{lang}wcf.shoutbox.entry.time{/lang}{if $sortField == 'time'} <img src="{@RELATIVE_WCF_DIR}icon/sort{@$sortOrder}S.png" alt="" />{/if}</a></div></th>
						
						{if $additionalColumnHeads|isset}{@$additionalColumnHeads}{/if}
					</tr>
				</thead>
				<tbody>
					{foreach from=$entries item=entry}
						<tr class="{cycle values="container-1,container-2" advance=false}">
							<td class="columnIcon">
								{if $entry->canDeleteEntry()}
									<a onclick="return confirm('{lang}wcf.shoutbox.entry.delete.sure{/lang}')" href="index.php?action=ShoutboxEntryDelete&amp;entryID={@$entry->entryID}{@SID_ARG_2ND}"><img src="{@RELATIVE_WCF_DIR}icon/deleteS.png" alt="" title="{lang}wcf.shoutbox.entry.delete{/lang}" /></a>
								{else}
									<img src="{@RELATIVE_WCF_DIR}icon/deleteDisabledS.png" alt="" title="{lang}wcf.shoutbox.entry.delete{/lang}" />
								{/if}
								
								{if $additionalButtons[$entry->entryID]|isset}{@$additionalButtons[$entry->entryID]}{/if}
							</td>
							<td class="columnEntryID columnID">{@$entry->entryID}</td>
							<td class="columnUsername columnText"><a href="index.php?page=User&amp;userID={@$entry->userID}{@SID_ARG_2ND}">{$entry->username}</a></td>
							<td class="columnMessage columnText">{@$entry->getFormattedMessage()}</td>
							<td class="columnTime columnText">{@$entry->time|shorttime}</td>
							
							{if $additionalColumns[$entry->entryID]|isset}{@$additionalColumns[$entry->entryID]}{/if}
						</tr>
					{/foreach}
				</tbody>
			</table>
		</div>
		<div class="contentFooter">
			{@$pagesLinks}
		</div>
	{else}
		<div class="border content">
			<div class="container-1">
				{lang}wcf.shoutbox.entry.archives.count.noEntries{/lang}
			</div>
		</div>
	{/if}

	
</div>

{include file='footer' sandbox=false}
</body>
</html>