<?php
// wcf imports
require_once(WCF_DIR.'lib/data/shoutbox/ShoutboxEntry.class.php');

/**
 * Provides functions to manage shoutbox entries.
 * 
 * @author	Sebastian ttl
 * @copyright	2009 Sebastian ttl
 * @license	GNU Lesser General Public License <http://opensource.org/licenses/lgpl-license.php>
 * @package	com.mysteryforce.wcf.shoutbox
 * @subpackage	lib.data.shoutbox
 * @category 	Shoutbox
 */
class ShoutboxEntryEditor extends ShoutboxEntry {
	/**
	 * Deletes this entry.
	 */
	public function delete() {
		$sql = "DELETE FROM	wcf".WCF_N."_shoutbox_entry
			WHERE		entryID = ".$this->entryID;
		WCF::getDB()->sendQuery($sql);
	}
	
	/**
	 * Creates a new shoutbox entry.
	 * 
	 * @param	integer			$userID
	 * @param	string			$username
	 * @param	integer			$time
	 * @param	string			$message
	 * @return	ShoutboxEntryEditor
	 */
	public static function create($userID, $username, $time, $message) {
		// save entry
		$sql = "INSERT INTO	wcf".WCF_N."_shoutbox_entry
					(userID, username, time, message)
			VALUES		(".$userID.", '".escapeString($username)."', ".$time.", '".escapeString($message)."')";
		WCF::getDB()->sendQuery($sql);
		
		// get id
		$entryID = WCF::getDB()->getInsertID("wcf".WCF_N."_shoutbox_entry", 'entryID');
		
		// get new object
		$entry = new ShoutboxEntryEditor($entryID);
		
		// return object
		return $entry;
	}
}
?>