use Plasma::FLUtf;
use Tie::InsertOrderHash;
use Win32::GUI;

my $path;
my $path2;
########################
# read cmp

sub readModel {
	open FILE, $_[0];
	binmode FILE;
	my $crypted = do {local $/; <FILE>};
	close FILE;
	my $tree = UTFread $crypted;
	return $tree;
}
sub exportHP {
	my $tree = readModel $path; 
	my @hplines;

	# get 3db
	my $obj = $tree->{'\\'}{Cmpnd}{Root}{'File name'};
	$obj =~ s/^\s+//g; # some cleaning
	$obj =~ s/\s+$//g;
	$obj =~ s/\000//g; # seems to leave nulls?

	#######################
	push @hplines, "# Exported from $path\n";
	
	my $HPF = $tree->{'\\'}{$obj}{Hardpoints}{Fixed};
	push @hplines, "[HpFixed]\n";

	grep { 
		my $key = $_; 
		my $line = "$key";
		my $ori = $HPF->{$key}{Orientation};
		my $pos = $HPF->{$key}{Position};
		my @o = unpack('fffffffff', $ori);
		my @p = unpack('fff', $pos);
		push @hplines, "$key = Orientation: ".join(', ',@o).
			'; Position: '.join(', ',@p)."\n"; 
	} keys %$HPF;


	my $HPR = $tree->{'\\'}{$obj}{Hardpoints}{Revolute};
	push @hplines, "\n[HpRevolute]\n";

	grep { 
		my $key = $_; 
		my $line = "$key";
		my $axis = $HPR->{$key}{Axis};
		my $min = $HPR->{$key}{Min};
		my $max = $HPR->{$key}{Max};
		my $ori = $HPR->{$key}{Orientation};
		my $pos = $HPR->{$key}{Position};
		my @a = unpack('fff', $axis);
		my @mi = unpack('ff', $min);
		my @ma = unpack('ff', $max);
		my @o = unpack('fffffffff<', $ori);
		my @p = unpack('fff', $pos);
		push @hplines, "$key = ".
			'Axis: '.join(', ',@a).
			'; Min: '.join(', ',@mi).
			'; Max: '.join(', ',@ma).
			'; Orientation: '.join(', ',@o).
			'; Position: '.join(', ',@p)."\n"; 
	} keys %$HPR;

	open FILE, '>',$path2;
	print FILE @hplines;
	close FILE;

}
sub importHP {

	my $imodel = readModel $path2; 

	my $iobj = $imodel->{'\\'}{Cmpnd}{Root}{'File name'};
	$iobj =~ s/^\s+//g; # some cleaning
	$iobj =~ s/\s+$//g;
	$iobj =~ s/\000//g; # seems to leave nulls?

	tie my %newhash,'Tie::InsertOrderHash';

	tie my %fixed,'Tie::InsertOrderHash';
	tie my %rev,'Tie::InsertOrderHash';
	%newhash = (Fixed => \%fixed, Revolute => \%rev);
	my @hplines;
	
	open FILE, $path;
	@hplines = <FILE>;
	close FILE;

	while (my $l = shift @hplines) {
		$l =~ s/[\r\n]//g;
		next unless $l;
		next if $l =~ /^\s+$/;
		if ($l =~ /^(\S+) = Orientation: ([^;]+); Position: ([^;]+)$/) { 
			my ($name,$ori,$pos) = ($1,$2,$3);
			$fixed{$name} = {
				Orientation => pack('f*',split(/, */,$ori)),
				Position => pack('f*',split(/, */,$pos)),
			};
		}
		
		if ($l =~ /^(\S+) = Axis: ([^;]+); Min: ([^;]+); Max: ([^;]+); Orientation: ([^;]+); Position: ([^;]+)$/) {
			my ($name,$axis,$min,$max,$ori,$pos) = ($1,$2,$3,$4,$5,$6);
			$rev{$name} = {
				Axis => pack('f*',split(/, */,$axis)),
				Min => pack('f*',split(/, */,$min)),
				Max => pack('f*',split(/, */,$max)),
				Orientation => pack('f*',split(/, */,$ori)),
				Position => pack('f*',split(/, */,$pos)),
			};
		
		}

	}

	$imodel->{'\\'}{$iobj}{Hardpoints} = \%newhash;

	my $code = UTFwriteUTF $imodel;
	open FILE, '>', $path2;
	binmode FILE;
	print FILE $code;
	close FILE;

}
sub importDirect {
	my $emodel = readModel $path; 
	my $imodel = readModel $path2; 


	my $eobj = $emodel->{'\\'}{Cmpnd}{Root}{'File name'};
	$eobj =~ s/^\s+//g; # some cleaning
	$eobj =~ s/\s+$//g;
	$eobj =~ s/\000//g; # seems to leave nulls?



#	tie my %newhash,'Tie::InsertOrderHash';
	
#	%newhash = %{ $emodel->{'\\'}{$eobj}{Hardpoints} };

	my $iobj = $imodel->{'\\'}{Cmpnd}{Root}{'File name'};
	$iobj =~ s/^\s+//g; # some cleaning
	$iobj =~ s/\s+$//g;
	$iobj =~ s/\000//g; # seems to leave nulls?
	
#	$imodel->{'\\'}{$iobj}{Hardpoints} = \%newhash;

	$imodel->{'\\'}{$iobj}{Hardpoints} = $emodel->{'\\'}{$eobj}{Hardpoints};
	
	my $code = UTFwriteUTF $imodel;
	open FILE, '>', $path2;
	binmode FILE;
	print FILE $code;
	close FILE;

}


$path = Win32::GUI::GetOpenFileName(
	-title => 'Select Import File', 
	-filemustexist => 1,
	-pathmustexist => 1
	);
exit 0 unless $path;

$path2 = Win32::GUI::GetSaveFileName(-title => 'Select Export File');
exit 0 unless $path2;

if (-B $path && -B $path2) {  importDirect;  }
elsif (-B $path) {  exportHP;  }
elsif (-B $path2) {  importHP;  }

# if path and path2 are both utf, importDirect
# if path is utf and path2 text, exportHP
# if path is text and path2 utf, importHP
# if both text, copy file!


#importDirect;
#exportHP;
#importHP;


